/*
 * Infomaniak kDrive - Android
 * Copyright (C) 2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.drive.di

import android.app.Application
import android.content.Context
import com.infomaniak.core.inappreview.AppReviewSettingsRepository
import com.infomaniak.core.inappupdate.AppUpdateSettingsRepository
import com.infomaniak.drive.MainApplication
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object ApplicationModule {
    @Provides
    fun providesMainApplication(application: Application) = application as MainApplication

    @Provides
    fun providesApplicationContext(@ApplicationContext context: Context) = context

    @Provides
    @Singleton
    fun providesAppUpdateSettingsRepository(appContext: Context): AppUpdateSettingsRepository = AppUpdateSettingsRepository(appContext)

    @Provides
    @Singleton
    fun providesAppReviewSettingsRepository(appContext: Context): AppReviewSettingsRepository = AppReviewSettingsRepository(appContext)
}
