import java.util.Properties

/**
 * Don't change the order in this `plugins` block, it will mess things up.
 */
plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.junit5)
    alias(libs.plugins.kotlin.android)
    alias(libs.plugins.kotlin.kapt)
    alias(libs.plugins.navigation.safeargs)
    alias(libs.plugins.realm.android)
    alias(core.plugins.ksp)
    alias(core.plugins.dagger.hilt)
    alias(core.plugins.compose.compiler)
    alias(core.plugins.kotlin.parcelize)
}

val appCompileSdk: Int by rootProject.extra
val appTargetSdk: Int by rootProject.extra
val appMinSdk: Int by rootProject.extra
val javaVersion: JavaVersion by rootProject.extra

android {

    namespace = "com.infomaniak.drive"

    compileSdk = appCompileSdk

    ndkVersion = "28.0.13004108"

    defaultConfig {
        testInstrumentationRunnerArguments["runnerBuilder"] = "de.mannodermaus.junit5.AndroidJUnit5Builder"
        applicationId = "com.infomaniak.drive"
        minSdk = appMinSdk
        targetSdk = appTargetSdk
        versionCode = 5_011_007_01
        versionName = "5.11.7"

        setProperty("archivesBaseName", "kdrive-$versionName ($versionCode)")

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        buildConfigField("String", "CLIENT_ID", "\"9473D73C-C20F-4971-9E10-D957C563FA68\"")

        buildConfigField("String", "BUGTRACKER_DRIVE_BUCKET_ID", "\"app_drive\"")
        buildConfigField("String", "BUGTRACKER_DRIVE_PROJECT_NAME", "\"drive\"")
        buildConfigField("String", "GITHUB_REPO", "\"android-kdrive\"")
        buildConfigField("String", "GITHUB_REPO_URL", "\"https://github.com/Infomaniak/android-kdrive\"")

        resValue("string", "CLOUD_STORAGE_AUTHORITY", "com.infomaniak.drive.documents")
        resValue("string", "FILE_AUTHORITY", "com.infomaniak.drive.files")

        resValue("string", "EXPOSED_UPLOAD_DIR", "upload_media")
        resValue("string", "EXPOSED_OFFLINE_DIR", "offline_storage")
        resValue("string", "EXPOSED_PUBLIC_SHARE_DIR", "public_share")

        androidResources.localeFilters += arrayOf("en", "de", "es", "fr", "it")
    }

    compileOptions {
        sourceCompatibility = javaVersion
        targetCompatibility = javaVersion
    }

    kotlinOptions { jvmTarget = javaVersion.toString() }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }

    flavorDimensions += "distribution"
    productFlavors {
        create("standard") {
            // TODO: Move the line below in the plugins block, or find an alternative, because this is not actually applied conditionally.
            apply(plugin = "com.google.gms.google-services")

            isDefault = true
        }
        create("fdroid")
        create("preprod") {
            buildConfigField("String", "DRIVE_API_V1", "\"https://kdrive.preprod.dev.infomaniak.ch/drive/\"")
            buildConfigField("String", "DRIVE_API_V2", "\"https://kdrive.preprod.dev.infomaniak.ch/2/drive/\"")
            buildConfigField("String", "DRIVE_API_V3", "\"https://kdrive.preprod.dev.infomaniak.ch/3/drive/\"")
            matchingFallbacks += "standard"
        }
    }

    buildFeatures {
        viewBinding = true
        buildConfig = true
        compose = true
    }

    packaging {
        // There is a conflict between 'pdfium' and 'dotlottie' libs, which both have 'libc++_shared.so'
        jniLibs.pickFirsts.add("**/libc++_shared.so")
    }

    lint {
        // Temporary fix waiting for the gradual update of some libs (androidx lifecycle, mqtt)
        disable += "NullSafeMutableLiveData"
    }

    testOptions.unitTests.all {
        it.testLogging { events("passed", "skipped", "failed", "standardOut", "standardError") }
    }
}

val isRelease = gradle.startParameter.taskNames.any { it.contains("release", ignoreCase = true) }

val envProperties = rootProject.file("env.properties")
    .takeIf { it.exists() }
    ?.let { file -> Properties().also { it.load(file.reader()) } }


configurations.configureEach {
    // The Matomo SDK logs network issues to Timber, and the Sentry plugin detects the Timber dependency,
    // and adds its integration, which generates noise.
    // Since we're not using Timber for anything else, it's safe to completely disabled it,
}


dependencies {

    implementation(project(":Core"))
    implementation(project(":Core:Auth"))
    implementation(project(":Core:Avatar"))
    implementation(project(":Core:Coil"))
    implementation(project(":Core:CrossAppLogin:Back"))
    implementation(project(":Core:CrossAppLogin:Front"))
    implementation(project(":Core:FragmentNavigation"))
    implementation(project(":Core:InAppReview"))
    implementation(project(":Core:InAppUpdate"))
    implementation(project(":Core:Ktor"))
    implementation(project(":Core:Legacy"))
    implementation(project(":Core:Legacy:AppLock"))
    implementation(project(":Core:Legacy:BugTracker"))
    implementation(project(":Core:Matomo"))
    implementation(project(":Core:KSuite"))
    implementation(project(":Core:KSuite:KSuitePro"))
    implementation(project(":Core:KSuite:MyKSuite"))
    implementation(project(":Core:Network"))
    implementation(project(":Core:RecyclerView"))
    implementation(project(":Core:Sentry"))
    implementation(project(":Core:Thumbnails"))
    implementation(project(":Core:TwoFactorAuth:Front"))
    implementation(project(":Core:TwoFactorAuth:Back:WithUserDb"))
    implementation(project(":Core:Ui"))
    implementation(project(":Core:Ui:Compose:Basics"))
    implementation(project(":Core:Ui:Compose:Margin"))
    implementation(project(":Core:Ui:Compose:MaterialThemeFromXml"))
    implementation(project(":Core:Ui:View:EdgeToEdge"))

    // Compose
    implementation(platform(core.compose.bom))
    implementation(core.activity.compose)
    implementation(core.compose.foundation)
    implementation(core.compose.material3)
    implementation(core.compose.ui.tooling.preview)

    implementation(core.ktor.client.okhttp)
    implementation(core.ktor.client.core)
    implementation(core.ktor.client.json)
    implementation(core.ktor.client.content.negociation)

    implementation(core.androidx.work.runtime)
    androidTestImplementation(core.androidx.work.testing)

    implementation(core.androidx.datastore.preferences)

    implementation(core.androidx.concurrent.futures.ktx)
    implementation(libs.androidx.lifecycle.process)
    implementation(libs.androidx.viewpager2)
    implementation(libs.androidx.webkit)

    implementation(core.splitties.mainthread)

    implementation(core.hilt.android)
    implementation(core.hilt.work)
    ksp(core.hilt.compiler)
    ksp(core.hilt.androidx.compiler)

    implementation(libs.exoplayer)
    implementation(libs.exoplayer.core)
    implementation(libs.exoplayer.ui)
    implementation(libs.extension.okhttp)

    implementation(libs.android.pdfview)
    implementation(libs.gravity.snap.helper)
    implementation(core.lottie)
    implementation(libs.material.date.time.picker)
    implementation(libs.touch.image.view)

    implementation(libs.realm.android.adapters)

    "standardImplementation"(project(":Core:Notifications:Registration"))
    "standardImplementation"(libs.firebase.messaging.ktx)
    "standardImplementation"(libs.gs.sdk)

    implementation(libs.dd.plist)

    implementation(libs.paho.mqtt.android)

    testImplementation(libs.kotlin.faker)
    testImplementation(libs.mock.web.server)
    androidTestImplementation(libs.androidx.ui.automator)

    androidTestImplementation(libs.androidx.espresso.contrib) {
        // WorkAround for dependencies issue (see https://github.com/android/android-test/issues/861)
        exclude(group = libs.androidx.espresso.checker.get().group, module = libs.androidx.espresso.checker.get().name)
    }
    androidTestImplementation(libs.androidx.espresso.core)

    implementation(core.androidx.core.ktx)
    androidTestImplementation(core.androidx.rules)
    androidTestImplementation(core.androidx.runner)

    androidTestImplementation(libs.junit.jupiter.api)
    testImplementation(libs.junit.jupiter.api)
    testRuntimeOnly(libs.junit.jupiter.engine)

    androidTestImplementation(libs.android.test.core)
    androidTestRuntimeOnly(libs.android.test.runner)

    implementation(core.coil.gif)

    // Compose
    implementation(libs.androidx.ui.android)
}
android { lint { checkReleaseBuilds = false } }
