/*
 * Infomaniak Core - Android
 * Copyright (C) 2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.core.appversionchecker.data.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class AppPublishedVersion(
    val tag: String? = null,
    @SerialName("tag_updated_at")
    val tagUpdatedAt: String? = null,
    @SerialName("version_changelog")
    val versionChangelog: String? = null,
    val type: String? = null,
    @SerialName("build_version")
    val buildVersion: String? = null,
    @SerialName("build_min_os_version")
    val buildMinOsVersion: String? = null,
    @SerialName("download_link")
    val downloadLink: String? = null,
    val data: List<String>? = null
)
