/*
 * Infomaniak Core - Android
 * Copyright (C) 2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.core.appversionchecker.data.api

import com.infomaniak.core.appversionchecker.data.models.AppVersion
import com.infomaniak.core.network.INFOMANIAK_API_V1

internal object ApiRoutesAppVersion {
    fun appVersion(appName: String, store: AppVersion.Store): String {
        val platform = AppVersion.Platform.ANDROID.apiValue

        return "${INFOMANIAK_API_V1}/app-information/versions/${store.apiValue}/$platform/$appName"
    }

    fun appVersion(
        appName: String,
        store: AppVersion.Store,
        projectionFields: List<AppVersion.ProjectionFields>,
        channelFilter: AppVersion.VersionChannel?
    ): String {
        val parameters = buildString {
            projectionFields.takeIf { it.isNotEmpty() }?.let { append("?only=${projectionFields.joinToString(",") { it.value }}") }
            channelFilter?.let { append("&filter_versions[]=$channelFilter") }
        }

        return appVersion(appName, store) + parameters
    }
}
