/*
 * Infomaniak kDrive - Android
 * Copyright (C) 2024 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.drive.ui.menu

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import com.infomaniak.core.legacy.utils.getAttributes
import com.infomaniak.drive.R
import com.infomaniak.drive.databinding.ViewMenuItemBinding

class MenuItemView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    private val binding by lazy { ViewMenuItemBinding.inflate(LayoutInflater.from(context), this, true) }

    init {
        attrs?.getAttributes(context, R.styleable.MenuItemView) {
            with(binding) {
                title.text = getString(R.styleable.MenuItemView_title) ?: ""
                icon.setImageDrawable(getDrawable(R.styleable.MenuItemView_icon))
                getColorStateList(R.styleable.MenuItemView_iconColor)?.let {
                    icon.imageTintList = it
                }
            }
        }
    }

    override fun setOnClickListener(listener: OnClickListener?) = binding.root.setOnClickListener(listener)

    fun setTitle(title: String) {
        binding.title.text = title
    }
}
