import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
    `kotlin-dsl`
}

group = "com.imcys.bilibilias.buildlogic"

// Configure the build-logic plugins to target JDK 17
// This matches the JDK used to build the project, and is not related to what is running on device.
java {
    sourceCompatibility = JavaVersion.VERSION_17
    targetCompatibility = JavaVersion.VERSION_17
}

kotlin {
    compilerOptions {
        jvmTarget = JvmTarget.JVM_17
    }
}

dependencies {
    compileOnly(libs.android.gradlePlugin)
    compileOnly(libs.android.tools.common)
    compileOnly(libs.compose.gradlePlugin)
}

tasks {
    validatePlugins {
        enableStricterValidation = true
        failOnWarning = true
    }
}

gradlePlugin {
    plugins {
        register("androidApplication") {
            id = libs.plugins.bilibilias.android.application.get().pluginId
            implementationClass = "AndroidApplicationConventionPlugin"
        }
        register("androidLibrary") {
            id = libs.plugins.bilibilias.android.library.get().pluginId
            implementationClass = "AndroidLibraryConventionPlugin"
        }

        register("koin") {
            id = libs.plugins.bilibilias.android.koin.get().pluginId
            implementationClass = "KoinConventionPlugin"
            version = "unspecified"
        }

        register("ffmpegVerification"){
            id = libs.plugins.bilibilias.android.ffmpegVerification.get().pluginId
            implementationClass = "FFmpegVerificationConventionPlugin"
            version = "unspecified"
        }

        register("baiduJar"){
            id = libs.plugins.bilibilias.baidu.jar.get().pluginId
            implementationClass = "BaiduJarDownloadConventionPlugin"
            version = "unspecified"
        }

    }
}