/***************************************************************
 * Name:      productversion.h
 * Purpose:   Version identifiers for OpenMoneyBox
 * Author:    Igor Calì (igorcali@disroot.org)
 * Created:   2025-11-16
 * Copyright: Igor Calì (igorcali@disroot.org)
 * License:		GNU
 **************************************************************/

#ifndef PRODUCTVERSIONS_H_INCLUDED
	#define PRODUCTVERSIONS_H_INCLUDED

	// VERSION INFORMATION
	//#define _ALPHA_						// alpha development
	//#define _BETA							// beta development
	//#define _RELCANDIDATE			// release candidate

	int MajorVersion = 3;
	int MinorVersion = 5;
	int ReleaseVersion = 1;
	#ifdef __OMB_WITH_PIE__
		int BuildVersion = 6;
	#endif // __OMB_WITH_PIE__

	// OpenMoneyBox database version
	#ifdef _OMB_USE_CIPHER
		int dbVersion = 39;
	#else
		int dbVersion = 38;
	#endif // _OMB_USE_CIPHER

	#ifdef __WXMAC__
		#include "mac_build.h"
	#else
		#ifndef __OPENSOLARIS__
			extern char __BUILD_NUMBER;
		#endif // __OPENSOLARIS__
		extern char   __BUILD_DATE;
	#endif // __WXMAC__
#endif // PRODUCTVERSIONS_H_INCLUDED
