/***************************************************************
 * Name:      indicator.cpp
 * Purpose:   Code for appindicator application
 * Author:    Igor Calì (igorcali@disroot.org)
 * Created:   2025-10-27
 * Copyright: Igor Calì (igorcali@disroot.org)
 * License:   GNU
 **************************************************************/

#include <sys/msg.h>
#include <errno.h>

#ifndef __UBUNTU_2510__
  #include <gtk/gtk.h>
#endif
#include <glib/gi18n.h>

#include <libintl.h>
#include <locale.h>

#ifdef __UBUNTU_2510__
	#include <libayatana-appindicator-glib/ayatana-appindicator.h>
#elif defined ( __UBUNTU_2204__ )
	#include <libayatana-appindicator/app-indicator.h>
#else
	#include <libappindicator/app-indicator.h>
#endif

#include "mailbox.h"

int msqidInd, msqidOmb;

bool initialization;	// true during initialization for mailbox on btCmnd_send_status
AppIndicator *indicator;

#ifdef __UBUNTU_2510__
  GMainLoop * m_pMainloop = NULL;
  GMenuItem *enable_menu_item;
#else
  static void ToggleAct (GtkWidget *widget);
#endif
static void RunOmbClick();
static void OptionsClick();
static void ExitClick();
static void Close();
static gboolean CheckCommand(gpointer data);

#ifdef __UBUNTU_2510__
  static void ToggleAct (GSimpleAction *pAction, GVariant *pValue, gpointer pData){
#else
  static void ToggleAct (GtkWidget *widget){
#endif

	if(initialization){
	  #ifdef __UBUNTU_2510__
	    g_menu_item_set_action_and_target_value(enable_menu_item, "activate", NULL);
          #else
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), TRUE);
	  #endif
	  return;}
  omb_msgbuf command, init_message;
  command.mtype = btCmd_do_action;
  command.value = cmd_toggle_enable;
	msgsnd( msqidInd, &command, sizeof(command), 0);

	msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_send_status, 0);
	if(init_message.value == tray_disabled){
	  #ifdef __UBUNTU_2510__
		app_indicator_set_icon(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_disabled.png", _("Tray icon disabled"));
		g_menu_item_set_action_and_target_value(enable_menu_item, "", NULL);
	  #else
		app_indicator_set_icon_full(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_disabled.png", _("Tray icon disabled"));
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), FALSE);
	  #endif
	}
	else if(init_message.value == tray_enabled){
	  #ifdef __UBUNTU_2510__
	    app_indicator_set_icon(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_pale.png", _("Tray icon enabled"));
            g_menu_item_set_action_and_target_value(enable_menu_item, "activate", NULL);
	  #else
	    app_indicator_set_icon_full(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_pale.png", _("Tray icon enabled"));
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), TRUE);
	  #endif
      }}

static void RunOmbClick (){
  omb_msgbuf command, init_message;
  command.mtype = btCmd_do_action;
  command.value = cmd_run_openmoneybox;
	msgsnd( msqidInd, &command, sizeof(command), 0);

	msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_kill, 0);
	Close();}

static void OptionsClick (){
  omb_msgbuf command, init_message;
  command.mtype = btCmd_do_action;
  command.value = cmd_open_options;
	msgsnd( msqidInd, &command, sizeof(command), 0);

	app_indicator_set_status (indicator, APP_INDICATOR_STATUS_PASSIVE);

	msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_kill, 0);
	if (init_message.value == cmd_close)Close();

	app_indicator_set_status (indicator, APP_INDICATOR_STATUS_ACTIVE);}

static void ExitClick (){
  omb_msgbuf command, init_message;
  command.mtype = btCmd_do_action;
  command.value = cmd_close;
	msgsnd( msqidInd, &command, sizeof(command), 0);

	msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_kill, 0);
	Close();}

static void Close (){
  #ifdef __UBUNTU_2510__
    g_main_loop_quit(m_pMainloop);
  #else
    gtk_main_quit();
  #endif
}

static gboolean CheckCommand (gpointer data){
	omb_msgbuf status_message;
	if(msgrcv( msqidOmb, &status_message, sizeof(status_message), btCmd_kill, IPC_NOWAIT) != -1){
		if( status_message.value == cmd_close){
			Close();
			return FALSE;}}
	if(msgrcv( msqidOmb, &status_message, sizeof(status_message), btCmd_send_status, IPC_NOWAIT) != -1) switch(status_message.value){
		case tray_attention:
			app_indicator_set_status (indicator, APP_INDICATOR_STATUS_ATTENTION);
			break;
		default:
			if (app_indicator_get_status(indicator) == APP_INDICATOR_STATUS_ATTENTION)
				app_indicator_set_status (indicator, APP_INDICATOR_STATUS_ACTIVE);}
	return TRUE;}

int main (int argc, char **argv){
	setlocale(LC_ALL, "");    // decided by environment
	#ifdef _OMB_DEBUG
		bindtextdomain("openmoneybox", "./");
	#else
		bindtextdomain("openmoneybox", "/usr/share/locale");
	#endif // _OMB_DEBUG
	textdomain("openmoneybox");

  #ifndef __UBUNTU_2510__
    GtkWidget *window;

    gtk_init (&argc, &argv);

  /* main window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("File"));
  gtk_window_set_icon_name (GTK_WINDOW (window), "indicator-messages-new");
  #endif

  #ifndef __UBUNTU_2510__
  g_signal_connect (G_OBJECT (window),
                    "destroy",
                    G_CALLBACK (
											/*
                      #ifdef __UBUNTU_2510__
                        g_exit_main_loop
                      #else
                      */
                        gtk_main_quit
//                      #endif
                      ),
                    NULL);
  #endif

  #ifdef __UBUNTU_2510__
    GMenu *menu;
//    GMenuItem *enable_menu_item;
    menu = g_menu_new();
  #else
    GtkWidget *menu, *enable_menu_item, *item;
    menu = gtk_menu_new();
  #endif

  #ifdef __UBUNTU_2510__
    GMenu *menu_section1 = g_menu_new();

    enable_menu_item = g_menu_item_new(_("Enabled"), "indicator.setenabled");
    g_menu_append_item(menu_section1, enable_menu_item);
  #else
    enable_menu_item = gtk_check_menu_item_new_with_label(_("Enabled"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), enable_menu_item);
  #endif
  g_signal_connect(G_OBJECT(enable_menu_item), "activate", G_CALLBACK(ToggleAct), NULL);
  #ifndef __UBUNTU_2510__
    gtk_widget_show(enable_menu_item);
  #endif

	#ifdef _OMB_MONOLITHIC
	  #ifdef __UBUNTU_2510__
	    GMenuItem *item = g_menu_item_new(_("Show OpenMoneyBox"), "indicator.start");
	  #else
  	    item = gtk_menu_item_new_with_label(_("Show OpenMoneyBox"));
  	  #endif
	#else
  	  item = gtk_menu_item_new_with_label(_("Start OpenMoneyBox"));
	#endif // _OMB_MONOLITHIC
  #ifdef __UBUNTU_2510__
    g_menu_append_item(menu_section1, item);
  #else
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
  #endif
  g_signal_connect(item, "activate", G_CALLBACK(RunOmbClick), NULL);
  #ifdef __UBUNTU_2510__
    g_menu_append_section(menu, NULL, G_MENU_MODEL(menu_section1));
  #else
    gtk_widget_show(item);

    item = gtk_separator_menu_item_new();
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
    gtk_widget_show(item);
  #endif

  #ifdef __UBUNTU_2510__
    GMenu *menu_section2 = g_menu_new();

    GMenuItem *item1 = g_menu_item_new(_("Options"), "indicator.options");
    g_menu_append_item(menu_section2, item1);
  #else
    item = gtk_menu_item_new_with_label(_("Options"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
  #endif
  g_signal_connect(item, "activate", G_CALLBACK(OptionsClick), NULL);
  #ifndef __UBUNTU_2510__
    gtk_widget_show(item);
  #endif

  #ifdef __UBUNTU_2510__
    GMenuItem *item2 = g_menu_item_new(_("Exit"), "indicator.quit");
    g_menu_append_item(menu_section2, item2);
  #else
    item = gtk_menu_item_new_with_label(_("Exit"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
  #endif
  g_signal_connect(item, "activate", G_CALLBACK(ExitClick), NULL);

  #ifdef __UBUNTU_2510__
    g_menu_append_section(menu, NULL, G_MENU_MODEL(menu_section2));
  #else
    gtk_widget_show(item);
  #endif

  /* Indicator */
  indicator = app_indicator_new ("example-simple-client",
                                 "/usr/share/icons/hicolor/48x48/apps/logo_pale.png",
                                 APP_INDICATOR_CATEGORY_APPLICATION_STATUS);

  #ifdef __UBUNTU_2510__
    g_assert (APP_IS_INDICATOR (indicator));
    g_assert (G_IS_OBJECT (indicator));
  #endif

  app_indicator_set_status (indicator, APP_INDICATOR_STATUS_ACTIVE);
  #ifdef __UBUNTU_2510__
    app_indicator_set_attention_icon (indicator, "/usr/share/icons/hicolor/48x48/apps/ombtray_attention.png", _("Tray icon needs attention"));
  #else
    app_indicator_set_attention_icon_full (indicator, "/usr/share/icons/hicolor/48x48/apps/ombtray_attention.png", _("Tray icon needs attention"));
  #endif

  #ifdef __UBUNTU_2510__
    app_indicator_set_menu (indicator, G_MENU (menu));
  #else
    app_indicator_set_menu (indicator, GTK_MENU (menu));
  #endif

	//Create the Indicator Mailbox
	msqidInd = msgget(MAILBOX_INDICATOR, 0600 | IPC_CREAT);
	//Create the Ombtray Mailbox
	msqidOmb = msgget(MAILBOX_OMBTRAY, 0600 | IPC_CREAT);

	omb_msgbuf init_message;

	/*
	#ifdef _OMB_DEBUG
		while(msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_kill, IPC_NOWAIT) != -1){}
	#endif // _OMB_DEBUG
	*/

	initialization = true;
	#ifdef _OMB_DEBUG
        switch(tray_enabled){
    #else
        msgrcv( msqidOmb, &init_message, sizeof(init_message), btCmd_send_status, 0);
	switch(init_message.value){
	#endif // _OMB_DEBUG
		case tray_disabled:
                  #ifdef __UBUNTU_2510__
			app_indicator_set_icon(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_disabled.png", _("Tray icon disabled"));
			g_menu_item_set_action_and_target_value(enable_menu_item, "", NULL);
		  #else
			app_indicator_set_icon_full(indicator,"/usr/share/icons/hicolor/48x48/apps/logo_disabled.png", _("Tray icon disabled"));
			gtk_widget_set_sensitive(enable_menu_item,FALSE);
		  #endif
                  break;
		case tray_enabled:
                  #ifdef __UBUNTU_2510__
		    g_menu_item_set_action_and_target_value(enable_menu_item, "activate", NULL);
		  #else
		    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(enable_menu_item),TRUE);
		  #endif
	}
	initialization = false;

	g_timeout_add_seconds (1,
                       CheckCommand,
                       NULL);

  #ifdef __UBUNTU_2510__

    // dummy actions
    GSimpleActionGroup *pActions = g_simple_action_group_new ();

    GVariant *pCheck = g_variant_new_boolean (FALSE);
    GSimpleAction *pSimpleAction = g_simple_action_new_stateful ("check", NULL, pCheck);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_signal_connect (G_OBJECT(pSimpleAction), "activate", G_CALLBACK (ToggleAct), "1");
//    g_signal_connect(G_OBJECT(enable_menu_item), "activate", G_CALLBACK(ToggleAct), NULL);
    g_object_unref (pSimpleAction);
    GMenuItem *pItem = g_menu_item_new ("1", "indicator.check");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);

/*
    GVariant *pRadio = g_variant_new_string ("2");
    pSimpleAction = g_simple_action_new_stateful ("radio", G_VARIANT_TYPE_STRING, pRadio);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onItemActivate), "2");
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("2", "indicator.radio::2");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);

    pSimpleAction = g_simple_action_new ("sub", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_object_unref (pSimpleAction);
    pSimpleAction = g_simple_action_new ("sub1", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onItemActivate), "Sub 1");
    g_object_unref (pSimpleAction);
    pSimpleAction = g_simple_action_new ("sub2", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    IndicatorData cSub2Data = {pIndicator, "sub1"};
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onSensitivityActivate), &cSub2Data);
    g_object_unref (pSimpleAction);
    pSimpleAction = g_simple_action_new ("sub3", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onItemActivate), "Sub 3");
    g_object_unref (pSimpleAction);
    addSubmenu (pMenu, TRUE);

    pSimpleAction = g_simple_action_new ("sensitivity", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    IndicatorData cSensitivityData = {pIndicator, "sub"};
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onSensitivityActivate), &cSensitivityData);
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("Toggle 3", "indicator.sensitivity");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);

    pSimpleAction = g_simple_action_new ("setimage", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    IndicatorData cSetImageData = {pIndicator, GINT_TO_POINTER (4)};
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onImageActivate), &cSetImageData);
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("New", "indicator.setimage");
    GIcon *pIcon = g_themed_icon_new_with_default_fallbacks ("document-new");
    g_menu_item_set_icon (pItem, pIcon);
    g_object_unref (pIcon);
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);

    pSimpleAction = g_simple_action_new ("attention", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    IndicatorData cAttentionData = {pIndicator, GINT_TO_POINTER (5)};
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onAttentionActivate), &cAttentionData);
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("Get Attention", "indicator.attention");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);
    app_indicator_set_secondary_activate_target (pIndicator, "attention");

    pSimpleAction = g_simple_action_new ("showlabel", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    IndicatorData cShowLabelData = {pIndicator, GINT_TO_POINTER (6)};
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onLabelToggle), &cShowLabelData);
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("Show label", "indicator.showlabel");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);

    pSimpleAction = g_simple_action_new ("setlocalicon", NULL);
    g_action_map_add_action (G_ACTION_MAP (pActions), G_ACTION (pSimpleAction));
    g_signal_connect (pSimpleAction, "activate", G_CALLBACK (onLocalIcon), pIndicator);
    g_object_unref (pSimpleAction);
    pItem = g_menu_item_new ("Set Local Icon", "indicator.setlocalicon");
    g_menu_append_item (pMenu, pItem);
    g_object_unref (pItem);
*/
    // -------------

    app_indicator_set_menu (indicator, menu);
    g_object_unref (menu);
//    app_indicator_set_actions (indicator, pActions);
//    g_object_unref (pActions);
//    onLabelToggle (NULL, NULL, &cShowLabelData);
    m_pMainloop = g_main_loop_new (NULL, FALSE);
    g_main_loop_run (m_pMainloop);
  #else
    gtk_main ();
  #endif

  return 0;}

