/*
 *  Copyright (c) 2025 David Allison <davidallisongithub@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free Software
 *  Foundation; either version 3 of the License, or (at your option) any later
 *  version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *  PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ichi2.anki.browser

import android.content.Context
import android.content.Intent
import com.ichi2.anki.AnkiDroidApp
import com.ichi2.anki.CardBrowser
import com.ichi2.anki.libanki.CardId
import com.ichi2.anki.libanki.DeckId
import com.ichi2.anki.utils.Destination

/**
 * Opens the [CardBrowser]
 */
sealed interface BrowserDestination : Destination {
    data class ToDeck(
        val deckId: DeckId,
    ) : BrowserDestination {
        override fun toIntent(context: Context): Intent {
            AnkiDroidApp.instance.sharedPrefsLastDeckIdRepository.lastDeckId = deckId
            return Intent(context, CardBrowser::class.java)
        }
    }

    /**
     * Opens the [CardBrowser] with the specified deck selected,
     * and automatically scrolls to [cardId] if the card is present on the deck.
     */
    data class ToCard(
        val deckId: DeckId,
        val cardId: CardId,
    ) : BrowserDestination {
        override fun toIntent(context: Context): Intent {
            AnkiDroidApp.instance.sharedPrefsLastDeckIdRepository.lastDeckId = deckId
            return Intent(context, CardBrowser::class.java).apply {
                putExtra(EXTRA_CARD_ID_KEY, cardId)
            }
        }

        companion object {
            const val EXTRA_CARD_ID_KEY = "cardId"
        }
    }
}
