import com.android.build.gradle.internal.tasks.factory.dependsOn

plugins {
    alias(libs.plugins.android.library)
    alias(libs.plugins.kotlin.android)
}

group = "com.ichi2.anki"
version = "2.0.0"

kotlin {
    explicitApi()
}

android {
    namespace = "com.ichi2.anki.api"
    compileSdk =
        libs.versions.compileSdk
            .get()
            .toInt()

    buildFeatures {
        buildConfig = true
    }

    defaultConfig {
        minSdk =
            libs.versions.minSdk
                .get()
                .toInt()
        buildConfigField(
            "String",
            "READ_WRITE_PERMISSION",
            "\"com.ichi2.anki.permission.READ_WRITE_DATABASE\"",
        )
        buildConfigField("String", "AUTHORITY", "\"com.ichi2.anki.flashcards\"")
    }
    buildTypes {
        debug {
            buildConfigField(
                "String",
                "READ_WRITE_PERMISSION",
                "\"com.ichi2.anki.debug.permission.READ_WRITE_DATABASE\"",
            )
            buildConfigField("String", "AUTHORITY", "\"com.ichi2.anki.debug.flashcards\"")
        }
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        // enable explicit api mode for additional checks related to the public api
        // see https://kotlinlang.org/docs/whatsnew14.html#explicit-api-mode-for-library-authors
        freeCompilerArgs += "-Xexplicit-api=strict"
        jvmTarget = JavaVersion.VERSION_11.toString()
    }

}

apply(from = "../lint.gradle")

dependencies {
    implementation(libs.androidx.annotation)
    implementation(libs.kotlin.stdlib)
    testImplementation(libs.junit.jupiter)
    testImplementation(libs.junit.vintage.engine)
    testImplementation(libs.robolectric)
    testImplementation(libs.kotlin.test)

    lintChecks(project(":lint-rules"))
}

afterEvaluate {
}

val zipReleaseProvider =
    tasks.register("zipRelease", Zip::class) {
        from(layout.buildDirectory.dir("repos/releases"))
        destinationDirectory = layout.buildDirectory
        archiveFileName = "${layout.buildDirectory.get()}/release-${archiveVersion.get()}.zip"
    }

// Use this task to make a release you can send to someone
val generateRelease: TaskProvider<Task> =
    tasks.register("generateRelease") {
        doLast {
            println("Release $version can be found at ${layout.buildDirectory.get()}/repos/releases/")
            println("Release $version zipped can be found ${layout.buildDirectory.get()}/release-$version.zip")
        }
    }

generateRelease.dependsOn(zipReleaseProvider)
