// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get appSettings => 'НАЛАШТУВАННЯ ЗАСТОСУНКУ';

  @override
  String get autoSmall => 'АВТО';

  @override
  String get back => 'Назад';

  @override
  String get cameraBehaviour => 'ПОВЕДІНКА КАМЕРИ';

  @override
  String get captureAtVolumePress =>
      'Захоплення при натисканні кнопки гучності';

  @override
  String get captureAtVolumePress_description =>
      'Якщо ввімкнено, натискання кнопки гучності зробить знімок або запише відео';

  @override
  String get choosePath => 'Виберіть шлях';

  @override
  String get defaultExposure => 'Експозиція за замовчуванням';

  @override
  String get disableAudio => 'Вимкнути звук';

  @override
  String get disableAudio_description => 'Вимкнути звук під час запису відео';

  @override
  String get enableCompression => 'Увімкнути стиснення';

  @override
  String get enableCompression_description =>
      'Використовуйте стиснення при збереженні зображень, щоб заощадити місце на диску.';

  @override
  String get enableExposureSlider => 'Ввімкнути повзунок експозиції';

  @override
  String get enableExposureSlider_description =>
      'Якщо ввімкнено, з\'явиться повзунок для ручного регулювання експозиції';

  @override
  String get enableMaximumScreenBrightness => 'Максимальна яскравість екрану';

  @override
  String get enableMaximumScreenBrightness_description =>
      'Якщо ввімкнено, яскравість екрана вашого пристрою буде встановлено на максимальну';

  @override
  String get enableModeRow =>
      'Ввімкнути рядок режиму фокусування та експозиції';

  @override
  String get enableModeRow_description =>
      'Ввімкніть рядок знизу, щоб перемикати режими експозиції та фокусування';

  @override
  String get enableZoomSlider => 'Ввімкнути повзунок масштабу';

  @override
  String get enableZoomSlider_description =>
      'Якщо ввімкнено, з\'явиться повзунок для ручного регулювання масштабу';

  @override
  String get exposureMode => 'Режим експозиції';

  @override
  String get exposureModeAuto => 'АВТО ЕКСПОЗИЦІЯ';

  @override
  String get exposureModeLocked => 'ЕКСПОЗИЦІЯ ЗАБЛОКОВАНА';

  @override
  String get flashlight => 'Ліхтарик';

  @override
  String get flipPhotosFrontCamera =>
      'Віддзеркалити фотографії на фронтальній камері';

  @override
  String get flipPhotosFrontCamera_description =>
      'Віддзеркалити фотографії горизонтально, які було зроблено фронтальною камерою';

  @override
  String get flipToFrontCamera => 'Переключити на фронтальну камеру';

  @override
  String get flipToRearCamera => 'Переключити на задню камеру';

  @override
  String get focusMode => 'Режим фокусування';

  @override
  String get focusModeAuto => 'АВТО ФОКУС';

  @override
  String get focusModeLocked => 'ФОКУС ЗАБЛОКОВАНО';

  @override
  String get format => 'Формат зображення';

  @override
  String get format_description =>
      'Змінити формат зображення (за замовчуванням: JPEG/JPG)';

  @override
  String get fps => 'Частота кадрів відео';

  @override
  String get fps_description =>
      'Високі частоти кадрів понад 60 fps залежать від вашого пристрою та вибраної роздільної здатності';

  @override
  String get getStarted => 'Розпочнемо';

  @override
  String get giveCameraPermission => 'Надати дозвіл камері';

  @override
  String get giveMicrophonePermission => 'Надати дозвіл мікрофону';

  @override
  String get giveStoragePermission => 'Надати дозвіл сховищу';

  @override
  String get imageCompressionQuality => 'Якість стиснення зображення';

  @override
  String get imageCompressionQuality_description =>
      'Стиснення до низької якості означає менший розмір, але гіршу якість, тоді як стиснення до вищої якості означає більший розмір, але кращу якість';

  @override
  String get keepEXIFMetadata => 'Зберегти дані EXIF';

  @override
  String get keepEXIFMetadata_description =>
      'Зберегти метадані EXIF зроблених знімків, як-от модель телефону, місцезнаходження GPS тощо.';

  @override
  String get language => 'Мова';

  @override
  String get language_description => 'Змінити мову застосунку';

  @override
  String get leftHandedMode => 'Лівосторонній режим';

  @override
  String get leftHandedMode_description =>
      'Якщо увімкнено, перемикає положення елементів керування камерою в альбомному режимі для лівосторонньої орієнтації';

  @override
  String get less => 'ПОКАЗУВАТИ МЕНШЕ';

  @override
  String get license =>
      'Код ліцензовано згідно GPLv3 на GitHub. Якщо ви зіткнулися з будь-якими проблемами або хочете подати запит на функцію, відкрийте питання на GitHub. Дякую!';

  @override
  String get lockCaptureOrientation =>
      'Заблокувати автоматичну орієнтацію [НЕОБХІДНО ПЕРЕЗАПУСТИТИ]';

  @override
  String get lockCaptureOrientation_description =>
      'Заблокувати орієнтацію в портретний режим, незалежно від того, чи ввімкнено автоматичний режим обертання';

  @override
  String get lockedSmall => 'ЗАБЛОКОВАНО';

  @override
  String get more => 'БІЛЬШЕ';

  @override
  String get next => 'Далі';

  @override
  String get off => 'Вимкнено';

  @override
  String get onboardingScreen => 'Екран підготовки';

  @override
  String get onboardingScreen_description =>
      'Відкрити початковий екран підготовки';

  @override
  String get openCapturedPictureOrVideo =>
      'Відкрити знятого зображення або відео';

  @override
  String get pauseVideo => 'Призупинити відео';

  @override
  String get permissionsTitle => 'ДОЗВОЛИ';

  @override
  String get permissionsTitle_description =>
      'Щоб користуватися камерою, потрібно надати дозвіл на використання камери та сховища.';

  @override
  String get reset => 'Скинути';

  @override
  String get resolution => 'Роздільна здатність';

  @override
  String get resolution_description => 'Змінити роздільну здатність камери';

  @override
  String get resumeVideo => 'Відновити відео';

  @override
  String get savePath => 'Зберегти шлях';

  @override
  String get savePathTitle => 'ЗБЕРЕГТИ ШЛЯХ';

  @override
  String get savePathTitle_description =>
      'Виберіть шлях для збереження. Зазвичай зображення зберігаються в DCIM на Android.';

  @override
  String savePath_description(String path) {
    return 'Поточний шлях: $path';
  }

  @override
  String get saving => 'ЗБЕРЕЖЕННЯ';

  @override
  String get selectPath => 'Вибрати шлях';

  @override
  String get settings => 'Налаштування';

  @override
  String get shutterSound => 'Увімкнути звук затвору';

  @override
  String get shutterSound_description =>
      'Увімкнути звук затвора під час фотографування';

  @override
  String get startRecordingVideo => 'Почати запис відео';

  @override
  String get startWithFrontCamera => 'Запуск з фронтальної камери';

  @override
  String get startWithFrontCamera_description =>
      'Завжди запускати з фронтальної камери під час відкриття застосунку';

  @override
  String get stopVideo => 'Зупинити відео';

  @override
  String get switchToPictureMode => 'Перейти в режим зображення';

  @override
  String get switchToVideoRecordingMode => 'Перейти в режим запису відео';

  @override
  String get systemLanguage => 'Системна мова';

  @override
  String get takePicture => 'Сфотографувати';

  @override
  String get theme => 'Тема';

  @override
  String get themeBlack => 'Чорна тема';

  @override
  String get themeDark => 'Темна тема';

  @override
  String get themeLight => 'Світла тема';

  @override
  String get themeSystem => 'Системна тема';

  @override
  String get theme_description => 'Змінити тему застосунку';

  @override
  String get timer => 'Таймер';

  @override
  String get useMaterialYou => 'Використовувати Material You';

  @override
  String get useMaterialYou_description =>
      'Використовувати Material You дизайн. Вимкніть старий дизайн Material';

  @override
  String version(String versionNumber) {
    return 'Версія $versionNumber';
  }

  @override
  String get welcomeTitle => 'ЛАСКАВО ПРОСИМО';

  @override
  String get welcomeTitle_description =>
      'Вітаємо! Ви готові використовувати цей застосунок для камери.';
}
