// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get appSettings => 'IMPOSTAZIONI APP';

  @override
  String get autoSmall => 'AUTO';

  @override
  String get back => 'Indietro';

  @override
  String get cameraBehaviour => 'IMPOSTAZIONI FOTOCAMERA';

  @override
  String get captureAtVolumePress => 'Scatta con tasti volume';

  @override
  String get captureAtVolumePress_description =>
      'Se abilitato, premere un tasto volume scatterà una foto o registrerà un video';

  @override
  String get choosePath => 'Scegli il percorso';

  @override
  String get defaultExposure => 'Esposizione predefinita';

  @override
  String get disableAudio => 'Disattiva audio';

  @override
  String get disableAudio_description =>
      'Disattiva l\'audio quando si registra un video';

  @override
  String get enableCompression => 'Abilita compressione';

  @override
  String get enableCompression_description =>
      'Usa la compressione quando salvi le immagini per risparmiare spazio di archiviazione';

  @override
  String get enableExposureSlider => 'Abilita cursore esposizione';

  @override
  String get enableExposureSlider_description =>
      'Se abilitato, appare un cursore per regolare manualmente l\'esposizione';

  @override
  String get enableMaximumScreenBrightness => 'Massima luminosità schermo';

  @override
  String get enableMaximumScreenBrightness_description =>
      'Se abilitato, la luminosità dello schermo viene impostata al massimo';

  @override
  String get enableModeRow => 'Abilita barra messa a fuoco ed esposizione';

  @override
  String get enableModeRow_description =>
      'Abilita una barra sul fondo per cambiare le modalità di esposizione e di messa a fuoco';

  @override
  String get enableZoomSlider => 'Abilita cursore zoom';

  @override
  String get enableZoomSlider_description =>
      'Se abilitato, appare un cursore per regolare manualmente lo zoom';

  @override
  String get exposureMode => 'Modalità esposizione';

  @override
  String get exposureModeAuto => 'ESPOSIZIONE AUTOMATICA';

  @override
  String get exposureModeLocked => 'ESPOSIZIONE BLOCCATA';

  @override
  String get flashlight => 'Torcia';

  @override
  String get flipPhotosFrontCamera => 'Capovolgi foto con fotocamera frontale';

  @override
  String get flipPhotosFrontCamera_description =>
      'Capovolge orizzontalmente le foto scattate con la fotocamera frontale';

  @override
  String get flipToFrontCamera => 'Passa a fotocamera frontale';

  @override
  String get flipToRearCamera => 'Passa a fotocamera posteriore';

  @override
  String get focusMode => 'Modalità messa a fuoco';

  @override
  String get focusModeAuto => 'FUOCO AUTOMATICO';

  @override
  String get focusModeLocked => 'FUOCO BLOCCATO';

  @override
  String get format => 'Formato di compressione immagine';

  @override
  String get format_description =>
      'Modifica il formato di compressione dell\'immagine (predefinito: JPEG/JPG)';

  @override
  String get fps => 'Frequenza fotogrammi video';

  @override
  String get fps_description =>
      'Frame rate elevati oltre 60 fps dipendono dal tuo dispositivo e dalla risoluzione selezionata';

  @override
  String get getStarted => 'Inizia';

  @override
  String get giveCameraPermission => 'Consenti l\'accesso alla fotocamera';

  @override
  String get giveMicrophonePermission => 'Consenti l\'accesso al microfono';

  @override
  String get giveStoragePermission => 'Consenti l\'accesso all\'archiviazione';

  @override
  String get imageCompressionQuality => 'Qualità di compressione immagine';

  @override
  String get imageCompressionQuality_description =>
      'Una minore qualità di compressione comporta dimensioni minori ma peggiore qualità, una qualità di compressione maggiore comporta dimensioni maggiori ma migliore qualità';

  @override
  String get keepEXIFMetadata => 'Salva dati EXIF';

  @override
  String get keepEXIFMetadata_description =>
      'Salva i metadati EXIF nell\'immagine come modello del telefono, posizione GPS, ecc.';

  @override
  String get language => 'Lingua';

  @override
  String get language_description => 'Cambia la lingua dell\'app';

  @override
  String get leftHandedMode => 'Modalità per mancini';

  @override
  String get leftHandedMode_description =>
      'Se abilitato, cambia la posizione dei comandi della fotocamera in orizzontale per la modalità per mancini';

  @override
  String get less => 'MOSTRA MENO';

  @override
  String get license =>
      'Il codice è rilasciato su licenza GPLv3 su GitHub. Se si riscontrano problemi o si desidera richiedere una funzionalità, si prega di aprire un issue su GitHub. Grazie!';

  @override
  String get lockCaptureOrientation =>
      'Blocca rotazione automatica [RIAVVIO NECESSARIO]';

  @override
  String get lockCaptureOrientation_description =>
      'Blocca l\'orientamento in modalità verticale, indipendentemento dalla modalità di rotazione automatica';

  @override
  String get lockedSmall => 'BLOCCATO';

  @override
  String get more => 'MOSTRA DI PIÙ';

  @override
  String get next => 'Avanti';

  @override
  String get off => 'Off';

  @override
  String get onboardingScreen => 'Schermata iniziale';

  @override
  String get onboardingScreen_description =>
      'Apri la schermata di configurazione iniziale';

  @override
  String get openCapturedPictureOrVideo =>
      'Apri l\'immagine o il video catturato';

  @override
  String get pauseVideo => 'Metti in pausa video';

  @override
  String get permissionsTitle => 'PERMESSI';

  @override
  String get permissionsTitle_description =>
      'Per utilizzare la fotocamera, è necessario dare l\'autorizzazione alla fotocamera e alla memoria d\'archiviazione.';

  @override
  String get reset => 'Reset';

  @override
  String get resolution => 'Risoluzione';

  @override
  String get resolution_description => 'Modifica la risoluzione';

  @override
  String get resumeVideo => 'Riprendi video';

  @override
  String get savePath => 'Percorso di salvataggio';

  @override
  String get savePathTitle => 'PERCORSO DI SALVATAGGIO';

  @override
  String get savePathTitle_description =>
      'Seleziona un percorso di salvataggio. Tipicamente in Android le immagini vengono salvate nella cartella DCIM.';

  @override
  String savePath_description(String path) {
    return 'Percorso attuale: $path';
  }

  @override
  String get saving => 'SALVATAGGIO';

  @override
  String get selectPath => 'Seleziona percorso';

  @override
  String get settings => 'Impostazioni';

  @override
  String get shutterSound => 'Abilita il suono dello scatto';

  @override
  String get shutterSound_description =>
      'Abilita il suono dello scatto quando si scatta una foto';

  @override
  String get startRecordingVideo => 'Inizia a registrare';

  @override
  String get startWithFrontCamera => 'Avvia con fotocamera frontale';

  @override
  String get startWithFrontCamera_description =>
      'Avvia sempre con la fotocamera frontale all\'apertura dell\'app';

  @override
  String get stopVideo => 'Ferma video';

  @override
  String get switchToPictureMode => 'Passa a modalità fotografia';

  @override
  String get switchToVideoRecordingMode => 'Passa a modalità video';

  @override
  String get systemLanguage => 'Lingua di sistema';

  @override
  String get takePicture => 'Scatta fotografia';

  @override
  String get theme => 'Tema';

  @override
  String get themeBlack => 'Tema nero';

  @override
  String get themeDark => 'Tema scuro';

  @override
  String get themeLight => 'Tema chiaro';

  @override
  String get themeSystem => 'Tema di sistema';

  @override
  String get theme_description => 'Modifica il tema dell\'app';

  @override
  String get timer => 'Timer';

  @override
  String get useMaterialYou => 'Usa Material You';

  @override
  String get useMaterialYou_description =>
      'Usa il design Material You. Disabilita per passare al vecchio design Material';

  @override
  String version(String versionNumber) {
    return 'Versione $versionNumber';
  }

  @override
  String get welcomeTitle => 'BENVENUTO';

  @override
  String get welcomeTitle_description =>
      'Congratulazioni! Sei pronto per utilizzare questa applicazione.';
}
