// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get appSettings => 'APP EINSTELLUNGEN';

  @override
  String get autoSmall => 'AUTO';

  @override
  String get back => 'Zurück';

  @override
  String get cameraBehaviour => 'KAMERAVERHALTEN';

  @override
  String get captureAtVolumePress =>
      'Aufnahme beim Drücken der Lautstärketasten';

  @override
  String get captureAtVolumePress_description =>
      'Wenn aktiviert, wird durch Drücken einer Lautstärketaste ein Foto oder ein Video aufgenommen';

  @override
  String get choosePath => 'Pfad auswählen';

  @override
  String get defaultExposure => 'Standard Belichtung';

  @override
  String get disableAudio => 'Ton deaktivieren';

  @override
  String get disableAudio_description =>
      'Deaktiviere den Ton beim Aufnehmen von Videos';

  @override
  String get enableCompression => 'Komprimierung aktivieren';

  @override
  String get enableCompression_description =>
      'Verwende Komprimierung beim Speichern von Bildern, um Speicherplatz zu sparen';

  @override
  String get enableExposureSlider => 'Belichtungs-Schieberegler aktiveren';

  @override
  String get enableExposureSlider_description =>
      'Wenn aktiviert, erscheint ein Schieberegler an der Seite, um die Belichtung manuell zu verstellen';

  @override
  String get enableMaximumScreenBrightness => 'Maximale Bildschirmhelligkeit';

  @override
  String get enableMaximumScreenBrightness_description =>
      'Wenn aktiviert, wird die Bildschirmhelligkeit deines Geräts auf das Maximum gesetzt';

  @override
  String get enableModeRow =>
      'Reihe für den Fokus- und Belichtungsmodus aktivieren';

  @override
  String get enableModeRow_description =>
      'Zeige unten eine Reihe zum wechseln des Fokus- und Belichtungsmodus an';

  @override
  String get enableZoomSlider => 'Zoom-Schieberegler aktiveren';

  @override
  String get enableZoomSlider_description =>
      'Wenn aktiviert, erscheint ein Schieberegler an der Seite, um den Zoom manuell zu verstellen';

  @override
  String get exposureMode => 'Belichtungsmodus';

  @override
  String get exposureModeAuto => 'AUTOMATISCHE BELICHTUNG';

  @override
  String get exposureModeLocked => 'GESPERRTE BELICHTUNG';

  @override
  String get flashlight => 'Taschenlampe';

  @override
  String get flipPhotosFrontCamera => 'Fotos der Frontkamera horizontal drehen';

  @override
  String get flipPhotosFrontCamera_description =>
      'Drehe die mit der Frontkamera aufgenommenen Fotos horizontal um';

  @override
  String get flipToFrontCamera => 'Zur Frontkamera wechseln';

  @override
  String get flipToRearCamera => 'Zur Rückkamera wechseln';

  @override
  String get focusMode => 'Fokusmodus';

  @override
  String get focusModeAuto => 'AUTOMATISCHER FOKUS';

  @override
  String get focusModeLocked => 'GESPERRTER FOKUS';

  @override
  String get format => 'Bildkomprimierungsformat';

  @override
  String get format_description =>
      'Ändere das Bildkomprimierungsformat (Standardformat: JPEG/JPG)';

  @override
  String get fps => 'Video-Bildrate';

  @override
  String get fps_description =>
      'Hohe Bildraten über 60 fps hängen von deinem Gerät und der gewählten Auflösung ab';

  @override
  String get getStarted => 'Jetzt loslegen';

  @override
  String get giveCameraPermission => 'Kamera-Berechtigung erteilen';

  @override
  String get giveMicrophonePermission => 'Mikrofon-Berechtigung erteilen';

  @override
  String get giveStoragePermission => 'Speicher-Berechtigung erteilen';

  @override
  String get imageCompressionQuality => 'Komprimierungsqualität';

  @override
  String get imageCompressionQuality_description =>
      'Geringere Komprimierungsqualität führt zu schlechterer Bildqualität mit geringerer Dateigröße, während höhere Komprimierungsqualität zu besserer Bildqualität mit höherer Dateigröße führt';

  @override
  String get keepEXIFMetadata => 'EXIF-Metadaten speichern';

  @override
  String get keepEXIFMetadata_description =>
      'EXIF-Metadaten des aufgenommenen Fotos speichern wie Handymodell, GPS-Standort, etc.';

  @override
  String get language => 'Sprache';

  @override
  String get language_description => 'Sprache der App ändern';

  @override
  String get leftHandedMode => 'Linkshänder-Modus';

  @override
  String get leftHandedMode_description =>
      'Wenn aktiviert, wird die Position der Kamerabedienelemente im Querformat für Linkshänder geändert';

  @override
  String get less => 'WENIGER ANZEIGEN';

  @override
  String get license =>
      'Der Quellcode ist unter der GPLv3 lizenziert und auf GitHub verfügbar. Wenn irgendwelche Probleme auftreten oder du einen Wunsch für ein Feature hast, öffne bitte ein \'Issue\' auf GitHub. Danke!';

  @override
  String get lockCaptureOrientation =>
      'Automatische Bildschirmausrichtung sperren [NEUSTART ERFORDERLICH]';

  @override
  String get lockCaptureOrientation_description =>
      'Sperrt die Bildschirmausrichtung zum Portrait-Modus, auch wenn die automatische Bildschirmausrichtung aktiviert ist';

  @override
  String get lockedSmall => 'GESPERRT';

  @override
  String get more => 'MEHR';

  @override
  String get next => 'Weiter';

  @override
  String get off => 'Aus';

  @override
  String get onboardingScreen => 'Einführungsseite';

  @override
  String get onboardingScreen_description => 'Öffne die Einführungsseite';

  @override
  String get openCapturedPictureOrVideo =>
      'Öffne das aufgenommene Foto oder Video';

  @override
  String get pauseVideo => 'Videoaufnahme pausieren';

  @override
  String get permissionsTitle => 'BERECHTIGUNGEN';

  @override
  String get permissionsTitle_description =>
      'Um die Kamera zu benutzen, musst du die Berechtigung für die Nutzung der Kamera und des Speichers erteilen.';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get resolution => 'Auflösung';

  @override
  String get resolution_description => 'Ändere die Kameraauflösung';

  @override
  String get resumeVideo => 'Videoaufnahme fortsetzen';

  @override
  String get savePath => 'Speicherpfad';

  @override
  String get savePathTitle => 'SPEICHERPFAD';

  @override
  String get savePathTitle_description =>
      'Wähle einen Speicherpfad aus. In Android ist dies normalerweise der DCIM Pfad.';

  @override
  String savePath_description(String path) {
    return 'Ausgewählter Pfad: $path';
  }

  @override
  String get saving => 'SPEICHERN';

  @override
  String get selectPath => 'Pfad auswählen';

  @override
  String get settings => 'Einstellungen';

  @override
  String get shutterSound => 'Auslöseton aktivieren';

  @override
  String get shutterSound_description =>
      'Aktiviere den Auslöseton bei der Aufnahme eines Bildes';

  @override
  String get startRecordingVideo => 'Videoaufnahme starten';

  @override
  String get startWithFrontCamera => 'Mit der Frontkamera starten';

  @override
  String get startWithFrontCamera_description =>
      'Beim Öffnen der App immer mit der Frontkamera starten';

  @override
  String get stopVideo => 'Videoaufnahme stoppen';

  @override
  String get switchToPictureMode => 'Zum Foto-Modus wechseln';

  @override
  String get switchToVideoRecordingMode => 'Zum Videoaufnahme-Modus wechseln';

  @override
  String get systemLanguage => 'Systemsprache';

  @override
  String get takePicture => 'Foto aufnehmen';

  @override
  String get theme => 'Thema';

  @override
  String get themeBlack => 'Schwarzes Thema';

  @override
  String get themeDark => 'Dunkles Thema';

  @override
  String get themeLight => 'Helles Thema';

  @override
  String get themeSystem => 'Thema des Systems';

  @override
  String get theme_description => 'Thema der App wechseln';

  @override
  String get timer => 'Timer';

  @override
  String get useMaterialYou => 'Material You verwenden';

  @override
  String get useMaterialYou_description =>
      'Material You Design verwenden. Deaktivieren, um altes Material Design zu benutzen';

  @override
  String version(String versionNumber) {
    return 'Version $versionNumber';
  }

  @override
  String get welcomeTitle => 'WILLKOMMEN';

  @override
  String get welcomeTitle_description =>
      'Herzlichen Glückwunsch! Du bist bereit, diese Kamera-App zu nutzen.';
}
