import Foundation

class MapArgumentReader {
  
  let args: [String: Any]?
  
  init(_ args: [String: Any]?) {
    self.args = args
  }
  
  func string(key: String) -> String? {
    return args?[key] as? String
  }
  
  func int(key: String) -> Int? {
    return (args?[key] as? NSNumber)?.intValue
  }
  
  func stringArray(key: String) -> [String]? {
    return args?[key] as? [String]
  }
  
  func bool(key: String) -> Bool? {
    return args?[key] as? Bool
  }
}
