# Contributing

Pull requests are welcome! You can look at [issues](https://github.com/HunterColes/PokerPayout/issues) for contribution opportunities. For other changes, please open an issue first to discuss what you would like to change.

## How to Contribute

1. **Fork the repository**
2. **Create a feature branch** from `master`
3. **Make your changes** - see [README.md](README.md) for build instructions
4. **Test your changes** - make sure all tests pass
5. **Open a Pull Request** with a clear description

## Development Setup

See the [Build & Installation](README.md#build--installation) section in the README for:
- Prerequisites (Android Studio, Java 17)
- Build commands
- Testing procedures

## Guidelines

- Follow existing Kotlin conventions (KtLint and Detekt enabled)
- Keep commits focused and write clear PR descriptions  
- Add tests for new functionality when appropriate
- For large changes, open an issue first to discuss the approach
