package com.huntercoles.pokerpayout.core.design

import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

/**
 * Centralized dimension constants for consistent spacing throughout the app
 */
object PokerDimens {
    // Standard spacing scale
    val SpacingXXSmall: Dp = 2.dp
    val SpacingXSmall: Dp = 4.dp
    val SpacingSmall: Dp = 8.dp
    val SpacingMedium: Dp = 12.dp
    val SpacingDefault: Dp = 16.dp
    val SpacingLarge: Dp = 24.dp
    val SpacingXLarge: Dp = 32.dp
    val SpacingXXLarge: Dp = 48.dp
    val SpacingHuge: Dp = 64.dp
    
    // Card and elevation
    val ElevationNone: Dp = 0.dp
    val ElevationSmall: Dp = 2.dp
    val ElevationDefault: Dp = 4.dp
    val ElevationMedium: Dp = 8.dp
    val ElevationLarge: Dp = 16.dp
    
    // Border widths
    val BorderThin: Dp = 1.dp
    val BorderMedium: Dp = 2.dp
    val BorderThick: Dp = 4.dp
    
    // Corner radius
    val CornerSmall: Dp = 8.dp
    val CornerMedium: Dp = 12.dp
    val CornerDefault: Dp = 16.dp
    val CornerLarge: Dp = 24.dp
    
    // Icon sizes
    val IconSmall: Dp = 16.dp
    val IconMedium: Dp = 20.dp
    val IconDefault: Dp = 24.dp
    val IconLarge: Dp = 48.dp
    val IconXLarge: Dp = 64.dp
    
    // Playing card dimensions
    val CardWidth: Dp = 40.dp
    val CardHeight: Dp = 56.dp
    
    // Component heights
    val ButtonHeight: Dp = 48.dp
    val MinInputWidth: Dp = 120.dp
    val MaxInputWidth: Dp = 160.dp
    val TimerDisplayHeight: Dp = 120.dp
    val BottomSheetMaxHeight: Dp = 400.dp
}
