# Contributing to Poker Payout Calculator

Thank you for your interest in contributing! This project is community-driven and maintained by volunteers—your help is appreciated.

## Ways to contribute

- Report bugs or request features by opening an issue.
- Submit pull requests with fixes, features, docs, or tests.
- Improve documentation and screenshots.
- Help triage issues and review PRs.

## Quick start for developers

1. Fork the repository and clone your fork.
2. Create a branch for your change: `git checkout -b feature/your-feature`
3. Run the project build: `./gradlew clean assembleDebug` (Windows: `.\gradlew clean assembleDebug`)
4. Run tests: `./gradlew test` (Windows: `.\gradlew test`)
5. Commit and push your branch.
6. Open a Pull Request describing the change.

## Code style and tests

- Follow existing Kotlin style conventions. The project uses KtLint and Detekt.
- Add unit tests for new logic where appropriate.
- Keep commits small and focused; write clear PR descriptions.

## Branching & PRs

- Use feature branches and create PRs against `master`.
- If your PR is large, open an issue first to discuss the approach.

## Support & Communication

If you need help getting started, open an issue with the `help-wanted` label or ask for guidance on an existing issue.

Thanks — we appreciate your support and contributions!
