package com.hfut.schedule.logic.util.sys

import android.Manifest
import android.app.Activity
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Build
import android.os.Environment
import android.os.Handler
import android.os.Looper
import android.provider.Settings
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.net.toUri

object PermissionSet {
    @JvmStatic
    fun checkAndRequestStoragePermission(activity: Activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            if (!Environment.isExternalStorageManager()) {
                try {
                    val intent = Intent(Settings.ACTION_MANAGE_APP_ALL_FILES_ACCESS_PERMISSION)
                    intent.data = "package:${activity.packageName}".toUri()
                    activity.startActivityForResult(intent, 1)
                } catch (e: Exception) {
                    // 某些手机拉不出来 , 使用全局设置页面
                    val intent = Intent(Settings.ACTION_MANAGE_ALL_FILES_ACCESS_PERMISSION)
                    activity.startActivityForResult(intent, 1)
                }
            }

        } else {
            // Android 10 及以下
            val needReq = arrayOf(
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE
            ).any {
                ContextCompat.checkSelfPermission(activity, it) != PackageManager.PERMISSION_GRANTED
            }

            if (needReq) {
                ActivityCompat.requestPermissions(activity, arrayOf(
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
                ), 1)
            }
        }
    }

    @JvmStatic
    fun checkAndRequestCalendarPermission(activity: Activity) {
        Handler(Looper.getMainLooper()).post {
            if(
                ContextCompat.checkSelfPermission(activity,
                    Manifest.permission.WRITE_CALENDAR) == PackageManager.PERMISSION_GRANTED &&
                ContextCompat.checkSelfPermission(activity,
                    Manifest.permission.READ_CALENDAR) == PackageManager.PERMISSION_GRANTED) {
                return@post
            }
            if(ContextCompat.checkSelfPermission(activity,
                    Manifest.permission.READ_CALENDAR) != PackageManager.PERMISSION_GRANTED)
                ActivityCompat.requestPermissions(activity, arrayOf(Manifest.permission.READ_CALENDAR),1)
            if(ContextCompat.checkSelfPermission(activity,
                    Manifest.permission.WRITE_CALENDAR) != PackageManager.PERMISSION_GRANTED)
                ActivityCompat.requestPermissions(activity, arrayOf(Manifest.permission.WRITE_CALENDAR),1)
        }
    }
    @JvmStatic
    fun checkAndRequestCameraPermission(activity: Activity) {
        Handler(Looper.getMainLooper()).post {
            if(ContextCompat.checkSelfPermission(activity,Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED)
                ActivityCompat.requestPermissions(activity, arrayOf(Manifest.permission.CAMERA),1)
        }
    }
    @JvmStatic
    fun checkAndRequestNotificationPermission(activity: Activity) {
        Handler(Looper.getMainLooper()).post {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) { // Android 13 (API 33) 需要通知权限
                if (ContextCompat.checkSelfPermission(activity, Manifest.permission.POST_NOTIFICATIONS) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(activity, arrayOf(Manifest.permission.POST_NOTIFICATIONS), 1)
                }
            }
        }
    }
}