package com.hfut.schedule.ui.screen.home.search.function.jxglstu.totalCourse

import androidx.compose.animation.AnimatedContentScope
import androidx.compose.animation.ExperimentalSharedTransitionApi
import androidx.compose.animation.SharedTransitionScope
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.FilledTonalButton
import androidx.compose.material3.FilledTonalIconButton
import androidx.compose.material3.Icon
import androidx.compose.material3.MediumTopAppBar
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.res.painterResource
import androidx.navigation.NavHostController
import com.hfut.schedule.logic.network.util.MyApiParse.isNextOpen
import com.hfut.schedule.logic.util.storage.kv.DataStoreManager
import com.xah.uicommon.style.APP_HORIZONTAL_DP
import com.hfut.schedule.ui.component.container.TransplantListItem
import com.hfut.schedule.ui.component.screen.CustomTransitionScaffold
import com.hfut.schedule.ui.screen.AppNavRoute
import com.hfut.schedule.logic.enumeration.HazeBlurLevel
import com.xah.uicommon.style.color.topBarTransplantColor
import com.hfut.schedule.ui.util.navigation.navigateForTransition
import com.hfut.schedule.viewmodel.network.NetWorkViewModel
import com.hfut.schedule.ui.component.button.TopBarNavigationIcon
import com.xah.transition.component.iconElementShare
import com.xah.transition.state.LocalAnimatedContentScope
import com.xah.transition.state.LocalSharedTransitionScope
import com.xah.uicommon.component.text.ScrollText
import dev.chrisbanes.haze.hazeSource
import dev.chrisbanes.haze.rememberHazeState


@OptIn(ExperimentalMaterial3Api::class, ExperimentalSharedTransitionApi::class)
@Composable
fun CourseTotal(
    ifSaved : Boolean,
    navController : NavHostController,
) {
    val route = remember { AppNavRoute.TotalCourse.withArgs(ifSaved,"SEARCH") }

    TransplantListItem(
        headlineContent = { ScrollText(text = AppNavRoute.TotalCourse.label) },
        leadingContent = {
            Icon(painterResource(AppNavRoute.TotalCourse.icon), contentDescription = null,modifier = Modifier.iconElementShare( route = route))
        },
        modifier = Modifier.clickable {
            navController.navigateForTransition(AppNavRoute.TotalCourse,route)
        }
    )

}


@OptIn(ExperimentalSharedTransitionApi::class, ExperimentalMaterial3Api::class)
@Composable
fun TotalCourseScreen(
    vm : NetWorkViewModel,
    origin : String,
    ifSaved : Boolean,
    navController : NavHostController,
) {
    var next by remember { mutableStateOf(false) }
    var sortType by remember { mutableStateOf(true) }

    val blur by DataStoreManager.enableHazeBlur.collectAsState(initial = true)
    val hazeState = rememberHazeState(blurEnabled = blur)
    val scrollBehavior = TopAppBarDefaults.enterAlwaysScrollBehavior()
    val route = remember { AppNavRoute.TotalCourse.receiveRoute() }
        CustomTransitionScaffold (
            route = route,
            navHostController = navController,
            modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
            topBar = {
                MediumTopAppBar(
                    scrollBehavior = scrollBehavior,
//                    modifier = Modifier.topBarBlur(hazeState, ),
                    colors = topBarTransplantColor(),
                    title = { Text(AppNavRoute.TotalCourse.label) },
                    navigationIcon = {
                        TopBarNavigationIcon(navController, AppNavRoute.TotalCourse.withArgs(ifSaved,origin), AppNavRoute.TotalCourse.icon)
                    },
                    actions = {
                        Row(modifier = Modifier.padding(horizontal = APP_HORIZONTAL_DP)) {
                            if (isNextOpen()) {
                                FilledTonalIconButton (
                                    onClick = {
                                        next = !next
                                    }
                                    ,) {
                                    Text(text = if(next) "下" else "本")
                                }
                            }
//                            Spacer(Modifier.width(CARD_NORMAL_DP))
                            FilledTonalButton(
                                onClick = { sortType = !sortType },) {
                                Text(text = if(sortType) "开课时间" else "学分高低")
                            }
                        }
                    }
                )
            },
        ) { innerPadding ->
            Column(
                modifier = Modifier
                    .hazeSource(hazeState)
                    .padding(innerPadding)
                    .fillMaxSize()
            ) {
                CourseTotalUI(
                    if(next) TotalCourseDataSource.MINE_NEXT else TotalCourseDataSource.MINE,
                    sortType,
                    vm,
                    hazeState,
                    ifSaved
                )
            }
        }
//    }
}


