package com.hfut.schedule.ui.component.network

import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.aspectRatio
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.Composable
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.asImageBitmap
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import com.hfut.schedule.R
import com.hfut.schedule.logic.util.ocr.TesseractUtils.recognizeCaptcha
import com.hfut.schedule.logic.util.other.rememberImageState
import com.hfut.schedule.logic.util.ocr.preprocessCaptcha
import com.hfut.schedule.logic.util.storage.kv.SharedPrefs.prefs
import com.hfut.schedule.logic.util.sys.Starter
import com.xah.uicommon.style.APP_HORIZONTAL_DP
import kotlinx.coroutines.launch


@Composable
fun UrlImage(
    url : String,
    cookie : String? = null,
    roundSize  : Dp =7.dp,
    width : Dp =70.dp,
    height : Dp = 70.dp,
    useCut : Boolean = true
) {
    val context = LocalContext.current
    val scope = rememberCoroutineScope()
    val modifierCut = if(useCut) {
        Modifier
            .clip(RoundedCornerShape(roundSize))
            .size(width = width,height= height)
            .aspectRatio(1f)
    } else {
        Modifier
            .clip(RoundedCornerShape(roundSize))
            .size(width = width,height= height)
    }
    Box(
        modifierCut
            .clip(RoundedCornerShape(roundSize))
            .size(width = width,height= height)
            .clickable {
               scope.launch {
                   Starter.startWebView(context,url,"图片",cookie)
               }
            }
    ) {
        val imageState = rememberImageState(url, cookie = cookie)
        imageState.value?.let { bitmap ->
            Image(
                bitmap = bitmap.asImageBitmap(),
                contentDescription = null,
                modifier = Modifier.fillMaxSize(),
                contentScale = ContentScale.Crop
            )
        } ?:
        Image(
            painterResource(R.drawable.ic_launcher_background),
            contentDescription = null,
            modifier = Modifier.fillMaxSize(),
            contentScale = ContentScale.Crop
        )
    }
}

@Composable
fun UrlImageNoCrop(
    url : String,
    cookie : String? = null,
    modifier: Modifier = Modifier.padding(APP_HORIZONTAL_DP)
) {
    val context = LocalContext.current
    val scope = rememberCoroutineScope()
    val imageState = rememberImageState(url, cookie = cookie)
    imageState.value?.let { bitmap ->
        Image(
            bitmap = bitmap.asImageBitmap(),
            contentDescription = null,
            modifier = modifier.clickable {
                scope.launch {
                    Starter.startWebView(context,url,"图片",cookie)
                }
            },
            contentScale = ContentScale.Fit
        )
    } ?:
    Image(
        painterResource(R.drawable.ic_launcher_background),
        contentDescription = null,
        modifier = modifier.clickable {
            scope.launch {
                Starter.startWebView(context,url,"图片",cookie)
            }
        },
        contentScale = ContentScale.Fit
    )
}

@Composable
fun UrlImageWithAutoOcr(
    url : String,
    cookie : String? = null,
    roundSize  : Dp =7.dp,
    width : Dp =70.dp,
    height : Dp = 70.dp,
    onResult : (String) -> Unit
) {
    Box(
        Modifier
            .clip(RoundedCornerShape(roundSize))
            .size(width = width,height= height)
    ) {
        val imageState = rememberImageState(url, cookie = cookie)
        imageState.value?.let { bitmap ->
            val preProgressed = preprocessCaptcha(bitmap)
            Image(
                bitmap = bitmap.asImageBitmap(),
                contentDescription = null,
                modifier = Modifier.fillMaxSize(),
                contentScale = ContentScale.Crop
            )
            val switch_open = prefs.getBoolean("SWITCH_ML",false)
            if(switch_open) {
                onResult(recognizeCaptcha(preProgressed))
            }
        } ?:
        Image(
            painterResource(R.drawable.ic_launcher_background),
            contentDescription = null,
            modifier = Modifier.fillMaxSize(),
            contentScale = ContentScale.Crop
        )
    }
}


