# Nextcloud Passwords

[![Android CI](https://github.com/hegocre/NextcloudPasswords/actions/workflows/android.yml/badge.svg?branch=main)](https://github.com/hegocre/NextcloudPasswords/actions/workflows/android.yml)
[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://github.com/hegocre/NextcloudPasswords/blob/main/LICENSE)
[![Crowdin](https://badges.crowdin.net/e/da2d6d8cb4ace3704592ebcf73969dc9/localized.svg)](https://hegocre.crowdin.com/nextcloud-passwords)
[![F-Droid Download](https://img.shields.io/f-droid/v/com.hegocre.nextcloudpasswords.svg?logo=F-Droid)](https://f-droid.org/packages/com.hegocre.nextcloudpasswords/)
[![GitHub Release](https://img.shields.io/github/release/hegocre/NextcloudPasswords.svg?logo=github)](https://github.com/hegocre/NextcloudPasswords/releases/)
[![Google Play Download](https://PlayBadges.pavi2410.me/badge/downloads?id=com.hegocre.nextcloudpasswords&pretty)](https://play.google.com/store/apps/details?id=com.hegocre.nextcloudpasswords)

This app connects to a Nextcloud server with Passwords App installed, and allows to view and edit its content on a user-friendly UI. It also acts as an AutoFill service, making logging in on Android devices easier.

## Features

- Display user passwords and folders on a Material Design UI
- Edit and create passwords, including custom fields
- Edit and create folders
- Show site icons, with cache to minimize data usage (optional)
- Supports self-signed certificates
- App lock screen with both passcode and biometric authentication
- Autofill service (Android 8.0 or higher)
- Uses the latest technologies like Kotlin and Jetpack Compose
- Privacy friendly: The only server this app connects is your own Nextcloud Server
- Free and Open Source

## Screenshots

| ![Light app lock view](/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png) | ![Light password list view](/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png) | ![Light password detail view](/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png) | ![Light password edit view](/fastlane/metadata/android/en-US/images/phoneScreenshots/4.png) |
|----------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|
| ![Dark app lock view](/fastlane/metadata/android/en-US/images/phoneScreenshots/5.png)  | ![Dark password list view](/fastlane/metadata/android/en-US/images/phoneScreenshots/6.png)  | ![Dark password detail view](/fastlane/metadata/android/en-US/images/phoneScreenshots/7.png)  | ![Dark password edit view](/fastlane/metadata/android/en-US/images/phoneScreenshots/8.png)  |

## Download

You can download the app from multiple sources. Keep in mind that each repository version is signed with a different key, which means it is not possible to switch between providers without uninstalling the previous APK first.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Download it on F-Droid" height="75">](https://f-droid.org/packages/com.hegocre.nextcloudpasswords/)
[<img src="https://user-images.githubusercontent.com/663460/26973090-f8fdc986-4d14-11e7-995a-e7c5e79ed925.png" alt="Download APK from GitHub" height="75">](https://github.com/hegocre/NextcloudPasswords/releases)
[<img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play" height="75">](https://play.google.com/store/apps/details?id=com.hegocre.nextcloudpasswords)

## Contribute

There are many ways you can contribute, including:

- Spread the word! Share the application to help the community grow. A review on Google Play is highly appreciated ⭐
- Help [translate the app](https://translations.hegocre.com/nextcloud-passwords)!. Make the app multilingual. The more languages, the more people it reaches! 🌏
- Contribute with the developement. Hop to the [Issues](https://github.com/hegocre/NextcloudPasswords/issues) page, and if you feel like working on something, be my guest! 🧑🏽‍💻
- [Make a donation](https://paypal.me/hegocre). Your generosity is the only source of income, and any small tip will be invested in coffee in order to survive those long coding nights 😴

## Contact

- Bugs and feature requests: [Issues](https://github.com/hegocre/NextcloudPasswords/issues)
- Email: nextcloudpasswords@hegocre.com

## License

	Copyright (C) 2023  Hèctor Godoy
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
