import 'dart:async';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:hive/hive.dart';
import 'package:pilipala/models/common/dynamic_badge_mode.dart';
import 'package:pilipala/pages/dynamics/index.dart';
import 'package:pilipala/pages/home/index.dart';
import 'package:pilipala/pages/media/index.dart';
import 'package:pilipala/pages/rank/index.dart';
import 'package:pilipala/utils/event_bus.dart';
import 'package:pilipala/utils/feed_back.dart';
import 'package:pilipala/utils/global_data.dart';
import 'package:pilipala/utils/storage.dart';
import './controller.dart';

class MainApp extends StatefulWidget {
  const MainApp({super.key});

  @override
  State<MainApp> createState() => _MainAppState();
}

class _MainAppState extends State<MainApp> with SingleTickerProviderStateMixin {
  final MainController _mainController = Get.put(MainController());
  final HomeController _homeController = Get.put(HomeController());
  final RankController _rankController = Get.put(RankController());
  final DynamicsController _dynamicController = Get.put(DynamicsController());
  final MediaController _mediaController = Get.put(MediaController());

  int? _lastSelectTime; //上次点击时间
  Box setting = GStrorage.setting;

  @override
  void initState() {
    super.initState();
    _lastSelectTime = DateTime.now().millisecondsSinceEpoch;
    _mainController.pageController =
        PageController(initialPage: _mainController.selectedIndex);
  }

  void setIndex(int value) async {
    feedBack();
    _mainController.pageController.jumpToPage(value);
    var currentPage = _mainController.pages[value];
    if (currentPage is HomePage) {
      if (_homeController.flag) {
        // 单击返回顶部 双击并刷新
        if (DateTime.now().millisecondsSinceEpoch - _lastSelectTime! < 500) {
          _homeController.onRefresh();
        } else {
          _homeController.animateToTop();
        }
        _lastSelectTime = DateTime.now().millisecondsSinceEpoch;
      }
      _homeController.flag = true;
    } else {
      _homeController.flag = false;
    }

    if (currentPage is RankPage) {
      if (_rankController.flag) {
        // 单击返回顶部 双击并刷新
        if (DateTime.now().millisecondsSinceEpoch - _lastSelectTime! < 500) {
          _rankController.onRefresh();
        } else {
          _rankController.animateToTop();
        }
        _lastSelectTime = DateTime.now().millisecondsSinceEpoch;
      }
      _rankController.flag = true;
    } else {
      _rankController.flag = false;
    }

    if (currentPage is DynamicsPage) {
      if (_dynamicController.flag) {
        // 单击返回顶部 双击并刷新
        if (DateTime.now().millisecondsSinceEpoch - _lastSelectTime! < 500) {
          _dynamicController.onRefresh();
        } else {
          _dynamicController.animateToTop();
        }
        _lastSelectTime = DateTime.now().millisecondsSinceEpoch;
      }
      _dynamicController.flag = true;
      _mainController.clearUnread();
    } else {
      _dynamicController.flag = false;
    }

    if (currentPage is MediaPage) {
      _mediaController.queryFavFolder();
    }
  }

  @override
  void dispose() async {
    await GStrorage.close();
    EventBus().off(EventName.loginEvent);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    Box localCache = GStrorage.localCache;
    double statusBarHeight = MediaQuery.of(context).padding.top;
    double sheetHeight = MediaQuery.sizeOf(context).height -
        MediaQuery.of(context).padding.top -
        MediaQuery.sizeOf(context).width * 9 / 16;
    localCache.put('sheetHeight', sheetHeight);
    localCache.put('statusBarHeight', statusBarHeight);
    return PopScope(
      canPop: false,
      onPopInvoked: (bool didPop) async {
        _mainController.onBackPressed(context);
      },
      child: Scaffold(
        extendBody: true,
        body: PageView(
          physics: const NeverScrollableScrollPhysics(),
          controller: _mainController.pageController,
          onPageChanged: (index) {
            _mainController.selectedIndex = index;
            setState(() {});
          },
          children: _mainController.pages,
        ),
        bottomNavigationBar: _mainController.navigationBars.length > 1
            ? StreamBuilder(
                stream: _mainController.hideTabBar
                    ? _mainController.bottomBarStream.stream.distinct()
                    : StreamController<bool>.broadcast().stream,
                initialData: true,
                builder: (context, AsyncSnapshot snapshot) {
                  return AnimatedSlide(
                    curve: Curves.easeInOutCubicEmphasized,
                    duration: const Duration(milliseconds: 500),
                    offset: Offset(0, snapshot.data ? 0 : 1),
                    child: GlobalData().enableMYBar
                        ? Obx(
                            () => NavigationBar(
                              onDestinationSelected: (value) => setIndex(value),
                              selectedIndex: _mainController.selectedIndex,
                              destinations: <Widget>[
                                ..._mainController.navigationBars.map((e) {
                                  return NavigationDestination(
                                    icon: Badge(
                                      label: _mainController
                                                  .dynamicBadgeType.value ==
                                              DynamicBadgeMode.number
                                          ? Text(e['count'].toString())
                                          : null,
                                      padding:
                                          const EdgeInsets.fromLTRB(6, 0, 6, 0),
                                      isLabelVisible: _mainController
                                                  .dynamicBadgeType.value !=
                                              DynamicBadgeMode.hidden &&
                                          e['count'] > 0,
                                      child: e['icon'],
                                    ),
                                    selectedIcon: e['selectIcon'],
                                    label: e['label'],
                                  );
                                }).toList(),
                              ],
                            ),
                          )
                        : Obx(
                            () => BottomNavigationBar(
                              currentIndex: _mainController.selectedIndex,
                              type: BottomNavigationBarType.fixed,
                              onTap: (value) => setIndex(value),
                              iconSize: 16,
                              selectedFontSize: 12,
                              unselectedFontSize: 12,
                              items: [
                                ..._mainController.navigationBars.map((e) {
                                  return BottomNavigationBarItem(
                                    icon: Badge(
                                      label: _mainController
                                                  .dynamicBadgeType.value ==
                                              DynamicBadgeMode.number
                                          ? Text(e['count'].toString())
                                          : null,
                                      padding:
                                          const EdgeInsets.fromLTRB(6, 0, 6, 0),
                                      isLabelVisible: _mainController
                                                  .dynamicBadgeType.value !=
                                              DynamicBadgeMode.hidden &&
                                          e['count'] > 0,
                                      child: e['icon'],
                                    ),
                                    activeIcon: e['selectIcon'],
                                    label: e['label'],
                                  );
                                }).toList(),
                              ],
                            ),
                          ),
                  );
                },
              )
            : null,
      ),
    );
  }
}
