import 'dart:async';
import 'dart:io';

import 'package:encrypt/encrypt.dart';
import 'package:flutter/material.dart';
import 'package:flutter_smart_dialog/flutter_smart_dialog.dart';
import 'package:get/get.dart';
import 'package:pilipala/http/login.dart';
import 'package:pilipala/models/login/index.dart';
import 'package:pilipala/utils/login.dart';

class LoginPageController extends GetxController {
  final GlobalKey mobFormKey = GlobalKey<FormState>();
  final GlobalKey passwordFormKey = GlobalKey<FormState>();
  final GlobalKey msgCodeFormKey = GlobalKey<FormState>();

  final TextEditingController mobTextController = TextEditingController();
  final TextEditingController passwordTextController = TextEditingController();
  final TextEditingController msgCodeTextController = TextEditingController();

  final FocusNode mobTextFieldNode = FocusNode();
  final FocusNode passwordTextFieldNode = FocusNode();
  final FocusNode msgCodeTextFieldNode = FocusNode();

  final PageController pageViewController = PageController();

  RxInt currentIndex = 0.obs;


  // 倒计时60s
  RxInt seconds = 60.obs;
  Timer? timer;
  RxBool smsCodeSendStatus = false.obs;

  // 默认密码登录
  RxInt loginType = 0.obs;

  late String captchaKey;

  late int tel;
  late int webSmsCode;

  RxInt validSeconds = 180.obs;
  Timer? validTimer;
  late String qrcodeKey;

  // 监听pageView切换
  void onPageChange(int index) {
    currentIndex.value = index;
  }

  // 输入手机号 下一页
  void nextStep() async {
    if ((mobFormKey.currentState as FormState).validate()) {
      await pageViewController.animateToPage(
        1,
        duration: const Duration(microseconds: 3000),
        curve: Curves.easeInOut,
      );
      passwordTextFieldNode.requestFocus();
      (mobFormKey.currentState as FormState).save();
    }
  }

  // 上一页
  void previousPage() async {
    passwordTextFieldNode.unfocus();
    await Future.delayed(const Duration(milliseconds: 200));
    pageViewController.animateToPage(
      0,
      duration: const Duration(microseconds: 300),
      curve: Curves.easeInOut,
    );
  }

  // 切换登录方式
  void changeLoginType() {
    loginType.value = loginType.value == 0 ? 1 : 0;
    if (loginType.value == 0) {
      passwordTextFieldNode.requestFocus();
    } else {
      msgCodeTextFieldNode.requestFocus();
    }
  }

  // app端密码登录
  void loginInByAppPassword() async {
    if ((passwordFormKey.currentState as FormState).validate()) {
      var webKeyRes = await LoginHttp.getWebKey();
      if (webKeyRes['status']) {
        String rhash = webKeyRes['data']['hash'];
        String key = webKeyRes['data']['key'];
        LoginHttp.loginInByMobPwd(
          tel: mobTextController.text,
          password: passwordTextController.text,
          key: key,
          rhash: rhash,
        );
      } else {
        SmartDialog.showToast(webKeyRes['msg']);
      }
    }
  }

  // web端密码登录
  void loginInByWebPassword() async {
    if ((passwordFormKey.currentState as FormState).validate()) {
    }
  }

  // web端验证码登录
  void loginInByCode() async {
    if ((msgCodeFormKey.currentState as FormState).validate()) {
      (msgCodeFormKey.currentState as FormState).save();
      var res = await LoginHttp.loginInByWebSmsCode(
        cid: 86,
        tel: tel,
        code: webSmsCode,
        captchaKey: captchaKey,
      );
      if (res['status']) {
        await LoginUtils.confirmLogin('', null);
      } else {
        SmartDialog.showToast(res['msg']);
      }
    }
  }

  // 获取app端验证码
  void getAppMsgCode() async {
  }

  // 申请极验验证码

  // 获取web端验证码
  void getWebMsgCode() async {
  }

  // 验证码倒计时
  void startTimer() {
    timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      if (seconds.value > 0) {
        seconds.value--;
      } else {
        seconds.value = 60;
        smsCodeSendStatus.value = false;
        timer.cancel();
      }
    });
  }

  // 获取登录二维码
  Future getWebQrcode() async {
    var res = await LoginHttp.getWebQrcode();
    validSeconds.value = 180;
    if (res['status']) {
      qrcodeKey = res['data']['qrcode_key'];
      validTimer = Timer.periodic(const Duration(seconds: 1), (validTimer) {
        if (validSeconds.value > 0) {
          validSeconds.value--;
          queryWebQrcodeStatus();
        } else {
          getWebQrcode();
          validTimer.cancel();
        }
      });
      return res;
    } else {
      SmartDialog.showToast(res['msg']);
    }
  }

  // 轮询二维码登录状态
  Future queryWebQrcodeStatus() async {
    var res = await LoginHttp.queryWebQrcodeStatus(qrcodeKey);
    if (res['status']) {
      await LoginUtils.confirmLogin('', null);
      validTimer?.cancel();
      Get.back();
    }
  }
}
