/*
 * Remote Numpad - a numpad application on Android for PCs lacking one.
 * Copyright (C) 2016-2022 Guillaume Payet
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.guillaumepayet.remotenumpad.connection

/**
 * A data sender generates data to be sent over an [IConnectionInterface].
 *
 * @see IConnectionInterface
 */
interface IDataSender {

    /**
     * Register an [IConnectionInterface] object through which data will be sent.
     *
     * @param connectionInterface the connection interface to register
     */
    fun registerConnectionInterface(connectionInterface: IConnectionInterface)

    /**
     * Unregister an [IConnectionInterface] object so data is no longer sent through it.
     *
     * @param connectionInterface the connection interface to unregister
     */
    fun unregisterConnectionInterface(connectionInterface: IConnectionInterface)
}