/*
*******************************************************************************    
*   BTChip Bitcoin Hardware Wallet Java API
*   (c) 2014 BTChip - 1BTChip7VfTnrPra5jqci7ejnMguuHogTn
*   
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*   limitations under the License.
********************************************************************************
*/

package com.btchip.utils;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureUtils {
	
	static class DummyFuture implements Future<byte[]> {
		
		private byte[] value;
		
		public DummyFuture(byte[] value) {
			this.value = value;
		}

		@Override
		public boolean cancel(boolean mayInterruptIfRunning) {
			return false;
		}

		@Override
		public byte[] get() {
			return value;
		}

		@Override
		public byte[] get(long timeout, TimeUnit unit) {
			return value;
		}

		@Override
		public boolean isCancelled() {
			return false;
		}

		@Override
		public boolean isDone() {
			return true;
		}
		
	}
	
	public static Future<byte[]> getDummyFuture(byte[] responseParam) {
		return new DummyFuture(responseParam);
	}

}
