package com.blockstream.green.data.countries

data class Country(val code: String, val name: String, val dialCode: Int, val flag: String) {
    val dialCodeString by lazy {
        "+$dialCode"
    }
}

object Countries {
    val Countries: List<Country> = listOf(
        Country("af", "Afghanistan", 93, "🇦🇫"),
        Country("al", "Albania", 355, "🇦🇱"),
        Country("dz", "Algeria", 213, "🇩🇿"),
        Country("as", "American Samoa", 1684, "🇦🇸"),
        Country("ad", "Andorra", 376, "🇦🇩"),
        Country("ao", "Angola", 244, "🇦🇴"),
        Country("ai", "Anguilla", 1264, "🇦🇮"),
        Country("ag", "Antigua and Barbuda", 1268, "🇦🇬"),
        Country("ar", "Argentina", 54, "🇦🇷"),
        Country("am", "Armenia", 374, "🇦🇲"),
        Country("aw", "Aruba", 297, "🇦🇼"),
        Country("au", "Australia", 61, "🇦🇺"),
        Country("at", "Austria", 43, "🇦🇹"),
        Country("az", "Azerbaijan", 994, "🇦🇿"),
        Country("bs", "Bahamas", 1242, "🇧🇸"),
        Country("bh", "Bahrain", 973, "🇧🇭"),
        Country("bd", "Bangladesh", 880, "🇧🇩"),
        Country("bb", "Barbados", 1246, "🇧🇧"),
        Country("by", "Belarus", 375, "🇧🇾"),
        Country("be", "Belgium", 32, "🇧🇪"),
        Country("bz", "Belize", 501, "🇧🇿"),
        Country("bj", "Benin", 229, "🇧🇯"),
        Country("bm", "Bermuda", 1441, "🇧🇲"),
        Country("bt", "Bhutan", 975, "🇧🇹"),
        Country("bo", "Bolivia", 591, "🇧🇴"),
        Country("ba", "Bosnia and Herzegovina", 387, "🇧🇦"),
        Country("bw", "Botswana", 267, "🇧🇼"),
        Country("br", "Brazil", 55, "🇧🇷"),
        Country("io", "British Indian Ocean Territory", 246, "🇮🇴"),
        Country("vg", "British Virgin Islands", 1284, "🇻🇬"),
        Country("bn", "Brunei", 673, "🇧🇳"),
        Country("bg", "Bulgaria", 359, "🇧🇬"),
        Country("bf", "Burkina Faso", 226, "🇧🇫"),
        Country("bi", "Burundi", 257, "🇧🇮"),
        Country("kh", "Cambodia", 855, "🇰🇭"),
        Country("cm", "Cameroon", 237, "🇨🇲"),
        Country("ca", "Canada", 1, "🇨🇦"),
        Country("cv", "Cabo Verde", 238, "🇨🇻"),
        Country("bq", "Caribbean Netherlands", 599, "🇧🇶"),
        Country("ky", "Cayman Islands", 1345, "🇰🇾"),
        Country("cf", "Central African Republic", 236, "🇨🇫"),
        Country("td", "Chad", 235, "🇹🇩"),
        Country("cl", "Chile", 56, "🇨🇱"),
        Country("cn", "China", 86, "🇨🇳"),
        Country("cx", "Christmas Island", 61, "🇨🇽"),
        Country("cc", "Cocos (Keeling) Islands", 61, "🇨🇨"),
        Country("co", "Colombia", 57, "🇨🇴"),
        Country("km", "Comoros", 269, "🇰🇲"),
        Country("cd", "Democratic Republic of the Congo", 243, "🇨🇩"),
        Country("cg", "Republic of the Congo", 242, "🇨🇬"),
        Country("ck", "Cook Islands", 682, "🇨🇰"),
        Country("cr", "Costa Rica", 506, "🇨🇷"),
        Country("ci", "Côte d'Ivoire", 225, "🇨🇮"),
        Country("hr", "Croatia", 385, "🇭🇷"),
        Country("cu", "Cuba", 53, "🇨🇺"),
        Country("cw", "Curaçao", 599, "🇨🇼"),
        Country("cy", "Cyprus", 357, "🇨🇾"),
        Country("cz", "Czech Republic", 420, "🇨🇿"),
        Country("dk", "Denmark", 45, "🇩🇰"),
        Country("dj", "Djibouti", 253, "🇩🇯"),
        Country("dm", "Dominica", 1767, "🇩🇲"),
        Country("do", "Dominican Republic", 1, "🇩🇴"),
        Country("ec", "Ecuador", 593, "🇪🇨"),
        Country("eg", "Egypt", 20, "🇪🇬"),
        Country("sv", "El Salvador", 503, "🇸🇻"),
        Country("gq", "Equatorial Guinea", 240, "🇬🇶"),
        Country("er", "Eritrea", 291, "🇪🇷"),
        Country("ee", "Estonia", 372, "🇪🇪"),
        Country("et", "Ethiopia", 251, "🇪🇹"),
        Country("fk", "Falkland Islands", 500, "🇫🇰"),
        Country("fo", "Faroe Islands", 298, "🇫🇴"),
        Country("fj", "Fiji", 679, "🇫🇯"),
        Country("fi", "Finland", 358, "🇫🇮"),
        Country("fr", "France", 33, "🇫🇷"),
        Country("gf", "French Guiana", 594, "🇬🇫"),
        Country("pf", "French Polynesia", 689, "🇵🇫"),
        Country("ga", "Gabon", 241, "🇬🇦"),
        Country("gm", "Gambia", 220, "🇬🇲"),
        Country("ge", "Georgia", 995, "🇬🇪"),
        Country("de", "Germany", 49, "🇩🇪"),
        Country("gh", "Ghana", 233, "🇬🇭"),
        Country("gi", "Gibraltar", 350, "🇬🇮"),
        Country("gr", "Greece", 30, "🇬🇷"),
        Country("gl", "Greenland", 299, "🇬🇱"),
        Country("gd", "Grenada", 1473, "🇬🇩"),
        Country("gp", "Guadeloupe", 590, "🇬🇵"),
        Country("gu", "Guam", 1671, "🇬🇺"),
        Country("gt", "Guatemala", 502, "🇬🇹"),
        Country("gg", "Guernsey", 44, "🇬🇬"),
        Country("gn", "Guinea", 224, "🇬🇳"),
        Country("gw", "Guinea-Bissau", 245, "🇬🇼"),
        Country("gy", "Guyana", 592, "🇬🇾"),
        Country("ht", "Haiti", 509, "🇭🇹"),
        Country("hn", "Honduras", 504, "🇭🇳"),
        Country("hk", "Hong Kong", 852, "🇭🇰"),
        Country("hu", "Hungary", 36, "🇭🇺"),
        Country("is", "Iceland", 354, "🇮🇸"),
        Country("in", "India", 91, "🇮🇳"),
        Country("id", "Indonesia", 62, "🇮🇩"),
        Country("ir", "Iran", 98, "🇮🇷"),
        Country("iq", "Iraq", 964, "🇮🇶"),
        Country("ie", "Ireland", 353, "🇮🇪"),
        Country("im", "Isle of Man", 44, "🇮🇲"),
        Country("il", "Israel", 972, "🇮🇱"),
        Country("it", "Italy", 39, "🇮🇹"),
        Country("jm", "Jamaica", 1876, "🇯🇲"),
        Country("jp", "Japan", 81, "🇯🇵"),
        Country("je", "Jersey", 44, "🇯🇪"),
        Country("jo", "Jordan", 962, "🇯🇴"),
        Country("kz", "Kazakhstan", 7, "🇰🇿"),
        Country("ke", "Kenya", 254, "🇰🇪"),
        Country("ki", "Kiribati", 686, "🇰🇮"),
        Country("kw", "Kuwait", 965, "🇰🇼"),
        Country("kg", "Kyrgyzstan", 996, "🇰🇬"),
        Country("la", "Laos", 856, "🇱🇦"),
        Country("lv", "Latvia", 371, "🇱🇻"),
        Country("lb", "Lebanon", 961, "🇱🇧"),
        Country("ls", "Lesotho", 266, "🇱🇸"),
        Country("lr", "Liberia", 231, "🇱🇷"),
        Country("ly", "Libya", 218, "🇱🇾"),
        Country("li", "Liechtenstein", 423, "🇱🇮"),
        Country("lt", "Lithuania", 370, "🇱🇹"),
        Country("lu", "Luxembourg", 352, "🇱🇺"),
        Country("mo", "Macao", 853, "🇲🇴"),
        Country("mk", "North Macedonia", 389, "🇲🇰"),
        Country("mg", "Madagascar", 261, "🇲🇬"),
        Country("mw", "Malawi", 265, "🇲🇼"),
        Country("my", "Malaysia", 60, "🇲🇾"),
        Country("mv", "Maldives", 960, "🇲🇻"),
        Country("ml", "Mali", 223, "🇲🇱"),
        Country("mt", "Malta", 356, "🇲🇹"),
        Country("mh", "Marshall Islands", 692, "🇲🇭"),
        Country("mq", "Martinique", 596, "🇲🇶"),
        Country("mr", "Mauritania", 222, "🇲🇷"),
        Country("mu", "Mauritius", 230, "🇲🇺"),
        Country("yt", "Mayotte", 262, "🇾🇹"),
        Country("mx", "Mexico", 52, "🇲🇽"),
        Country("fm", "Micronesia", 691, "🇫🇲"),
        Country("md", "Moldova", 373, "🇲🇩"),
        Country("mc", "Monaco", 377, "🇲🇨"),
        Country("mn", "Mongolia", 976, "🇲🇳"),
        Country("me", "Montenegro", 382, "🇲🇪"),
        Country("ms", "Montserrat", 1664, "🇲🇸"),
        Country("ma", "Morocco", 212, "🇲🇦"),
        Country("mz", "Mozambique", 258, "🇲🇿"),
        Country("mm", "Myanmar", 95, "🇲🇲"),
        Country("na", "Namibia", 264, "🇳🇦"),
        Country("nr", "Nauru", 674, "🇳🇷"),
        Country("np", "Nepal", 977, "🇳🇵"),
        Country("nl", "Netherlands", 31, "🇳🇱"),
        Country("nc", "New Caledonia", 687, "🇳🇨"),
        Country("nz", "New Zealand", 64, "🇳🇿"),
        Country("ni", "Nicaragua", 505, "🇳🇮"),
        Country("ne", "Niger", 227, "🇳🇪"),
        Country("ng", "Nigeria", 234, "🇳🇬"),
        Country("nu", "Niue", 683, "🇳🇺"),
        Country("nf", "Norfolk Island", 672, "🇳🇫"),
        Country("kp", "North Korea", 850, "🇰🇵"),
        Country("mp", "Northern Mariana Islands", 1670, "🇲🇵"),
        Country("no", "Norway", 47, "🇳🇴"),
        Country("om", "Oman", 968, "🇴🇲"),
        Country("pk", "Pakistan", 92, "🇵🇰"),
        Country("pw", "Palau", 680, "🇵🇼"),
        Country("ps", "Palestine", 970, "🇵🇸"),
        Country("pa", "Panama", 507, "🇵🇦"),
        Country("pg", "Papua New Guinea", 675, "🇵🇬"),
        Country("py", "Paraguay", 595, "🇵🇾"),
        Country("pe", "Peru", 51, "🇵🇪"),
        Country("ph", "Philippines", 63, "🇵🇭"),
        Country("pl", "Poland", 48, "🇵🇱"),
        Country("pt", "Portugal", 351, "🇵🇹"),
        Country("pr", "Puerto Rico", 1, "🇵🇷"),
        Country("qa", "Qatar", 974, "🇶🇦"),
        Country("re", "Réunion", 262, "🇷🇪"),
        Country("ro", "Romania", 40, "🇷🇴"),
        Country("ru", "Russia", 7, "🇷🇺"),
        Country("rw", "Rwanda", 250, "🇷🇼"),
        Country("bl", "Saint Barthélemy", 590, "🇧🇱"),
        Country("sh", "Saint Helena, Ascension and Tristan da Cunha", 290, "🇸🇭"),
        Country("kn", "Saint Kitts and Nevis", 1869, "🇰🇳"),
        Country("lc", "Saint Lucia", 1758, "🇱🇨"),
        Country("mf", "Saint Martin", 590, "🇲🇫"),
        Country("pm", "Saint Pierre and Miquelon", 508, "🇵🇲"),
        Country("vc", "Saint Vincent and the Grenadines", 1784, "🇻🇨"),
        Country("ws", "Samoa", 685, "🇼🇸"),
        Country("sm", "San Marino", 378, "🇸🇲"),
        Country("st", "São Tomé and Príncipe", 239, "🇸🇹"),
        Country("sa", "Saudi Arabia", 966, "🇸🇦"),
        Country("sn", "Senegal", 221, "🇸🇳"),
        Country("rs", "Serbia", 381, "🇷🇸"),
        Country("sc", "Seychelles", 248, "🇸🇨"),
        Country("sl", "Sierra Leone", 232, "🇸🇱"),
        Country("sg", "Singapore", 65, "🇸🇬"),
        Country("sx", "Sint Maarten", 1721, "🇸🇽"),
        Country("sk", "Slovakia", 421, "🇸🇰"),
        Country("si", "Slovenia", 386, "🇸🇮"),
        Country("sb", "Solomon Islands", 677, "🇸🇧"),
        Country("so", "Somalia", 252, "🇸🇴"),
        Country("za", "South Africa", 27, "🇿🇦"),
        Country("kr", "South Korea", 82, "🇰🇷"),
        Country("ss", "South Sudan", 211, "🇸🇸"),
        Country("es", "Spain", 34, "🇪🇸"),
        Country("lk", "Sri Lanka", 94, "🇱🇰"),
        Country("sd", "Sudan", 249, "🇸🇩"),
        Country("sr", "Suriname", 597, "🇸🇷"),
        Country("sj", "Svalbard and Jan Mayen", 47, "🇸🇯"),
        Country("sz", "Eswatini", 268, "🇸🇿"),
        Country("se", "Sweden", 46, "🇸🇪"),
        Country("ch", "Switzerland", 41, "🇨🇭"),
        Country("sy", "Syria", 963, "🇸🇾"),
        Country("tw", "Taiwan", 886, "🇹🇼"),
        Country("tj", "Tajikistan", 992, "🇹🇯"),
        Country("tz", "Tanzania", 255, "🇹🇿"),
        Country("th", "Thailand", 66, "🇹🇭"),
        Country("tl", "Timor-Leste", 670, "🇹🇱"),
        Country("tg", "Togo", 228, "🇹🇬"),
        Country("tk", "Tokelau", 690, "🇹🇰"),
        Country("to", "Tonga", 676, "🇹🇴"),
        Country("tt", "Trinidad and Tobago", 1868, "🇹🇹"),
        Country("tn", "Tunisia", 216, "🇹🇳"),
        Country("tr", "Türkiye", 90, "🇹🇷"),
        Country("tm", "Turkmenistan", 993, "🇹🇲"),
        Country("tc", "Turks and Caicos Islands", 1649, "🇹🇨"),
        Country("tv", "Tuvalu", 688, "🇹🇻"),
        Country("vi", "U.S. Virgin Islands", 1340, "🇻🇮"),
        Country("ug", "Uganda", 256, "🇺🇬"),
        Country("ua", "Ukraine", 380, "🇺🇦"),
        Country("ae", "United Arab Emirates", 971, "🇦🇪"),
        Country("gb", "United Kingdom", 44, "🇬🇧"),
        Country("us", "United States", 1, "🇺🇸"),
        Country("uy", "Uruguay", 598, "🇺🇾"),
        Country("uz", "Uzbekistan", 998, "🇺🇿"),
        Country("vu", "Vanuatu", 678, "🇻🇺"),
        Country("va", "Vatican City", 39, "🇻🇦"),
        Country("ve", "Venezuela", 58, "🇻🇪"),
        Country("vn", "Vietnam", 84, "🇻🇳"),
        Country("wf", "Wallis and Futuna", 681, "🇼🇫"),
        Country("eh", "Western Sahara", 212, "🇪🇭"),
        Country("ye", "Yemen", 967, "🇾🇪"),
        Country("zm", "Zambia", 260, "🇿🇲"),
        Country("zw", "Zimbabwe", 263, "🇿🇼"),
        Country("ax", "Åland Islands", 358, "🇦🇽")
    )
    
    fun getEmojiFlagOrDefault(countryCode: String): String {
        return Countries.find { it.code.equals(countryCode, ignoreCase = true) }?.flag ?: "🏳️"
    }
}