package com.blockstream.common.di

import com.blockstream.common.usecases.CheckRecoveryPhraseUseCase
import com.blockstream.common.usecases.EnableHardwareWatchOnlyUseCase
import com.blockstream.common.usecases.SetBiometricsUseCase
import com.blockstream.common.usecases.SetPinUseCase
import com.blockstream.common.utils.WatchOnlyDetector
import com.blockstream.domain.account.accountModule
import com.blockstream.domain.banner.GetBannerUseCase
import com.blockstream.domain.bitcoinpricehistory.ObserveBitcoinPriceHistory
import com.blockstream.domain.boltz.boltzModule
import com.blockstream.domain.hardware.VerifyAddressUseCase
import com.blockstream.domain.lightning.LightningNodeIdUseCase
import com.blockstream.domain.meld.*
import com.blockstream.domain.navigation.NavigateToWallet
import com.blockstream.domain.promo.GetPromoUseCase
import com.blockstream.domain.receive.receiveModule
import com.blockstream.domain.send.sendModule
import com.blockstream.domain.wallet.walletModule
import com.blockstream.green.data.dataModule
import com.blockstream.green.domain.domainModule
import org.koin.dsl.module

//At some point we'll move this to domain module.
val commonModule = module {
    includes(dataModule)
    includes(domainModule)
    includes(boltzModule)
    includes(sendModule)
    includes(receiveModule)
    includes(walletModule)
    includes(accountModule)
    single {
        WatchOnlyDetector(get())
    }
    single {
        LightningNodeIdUseCase(get())
    }
    single {
        NavigateToWallet(get(), get())
    }
    single {
        VerifyAddressUseCase(get())
    }
    single {
        CreateCryptoQuoteUseCase(get())
    }
    single {
        CreateCryptoWidgetUseCase(get())
    }
    single {
        DefaultValuesUseCase(get())
    }
    single {
        MeldUseCase(get(), get(), get())
    }
    single {
        CheckRecoveryPhraseUseCase(get())
    }
    single {
        SetBiometricsUseCase(get(), get())
    }
    single {
        SetPinUseCase(get())
    }
    single {
        EnableHardwareWatchOnlyUseCase(get(), get())
    }
    factory {
        ObserveBitcoinPriceHistory(get())
    }
    factory {
        GetLastSuccessfulPurchaseExchange(get())
    }
    single {
        GetBannerUseCase()
    }
    single {
        GetPromoUseCase(get(), get(), get())
    }
}
