package com.blockstream.ui.utils

import androidx.compose.foundation.lazy.LazyListState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier

inline fun Modifier.ifTrue(
    condition: Boolean,
    ifTrue: (Modifier) -> Modifier,
): Modifier = if (condition) {
    then(ifTrue(Modifier))
} else {
    this
}

inline fun Modifier.conditional(
    condition: Boolean,
    ifTrue: (Modifier) -> Modifier,
    ifFalse: (Modifier) -> Modifier = { this },
): Modifier = if (condition) {
    then(ifTrue(Modifier))
} else {
    then(ifFalse(Modifier))
}

inline fun <T> Modifier.nullConditional(
    argument: T?,
    ifNotNull: (Modifier, T) -> Modifier,
    ifNull: (Modifier) -> Modifier = { this },
): Modifier {
    return if (argument != null) {
        then(ifNotNull(Modifier, argument))
    } else {
        then(ifNull(Modifier))
    }
}

fun LazyListState.reachedBottom(): Boolean {
    val lastVisibleItem = this.layoutInfo.visibleItemsInfo.lastOrNull()
    return lastVisibleItem?.index != 0 && lastVisibleItem?.index == this.layoutInfo.totalItemsCount - 1
}

@Composable
fun composeIf(
    condition: Boolean?,
    content: @Composable () -> Unit,
) {
    if (condition != true) return

    return content()
}