package com.gpl.rpg.AndorsTrail.view;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.TextView;

//Thanks to https://stackoverflow.com/questions/6205339/listview-item-selected-state-not-working

public class SelectableTextView extends TextView implements Checkable {
	private static final int[] CHECKED_STATE_SET = {
			android.R.attr.state_checked
	};

	private boolean mChecked;

	public SelectableTextView(Context context) {
		super(context);
	}

	public SelectableTextView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public SelectableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
	}

//	@TargetApi(Build.VERSION_CODES.LOLLIPOP)
//	public SelectableTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
//		super(context, attrs, defStyleAttr, defStyleRes);
//	}

	@Override
	public void setChecked(boolean checked) {
		if (mChecked != checked) {
			mChecked = checked;
			refreshDrawableState();
		}
	}

	@Override
	public boolean isChecked() {
		return mChecked;
	}

	@Override
	public void toggle() {
		setSelected(!mChecked);
	}

	@Override
	protected int[] onCreateDrawableState(int extraSpace) {
		final int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
		if (isChecked()) {
			mergeDrawableStates(drawableState, CHECKED_STATE_SET);
		}
		return drawableState;
	}
}
