# GPA Calculator

[![Try It Online](https://img.shields.io/badge/Live%20Demo-Web%20App-blue?logo=flutter&logoColor=white)](https://mllrr96.github.io/Gpa-Calculator/)

A simple Flutter app that helps AUIS students calculate their GPA based on letter grades and credit hours.

> 🎓 **Note:** This app is tailored for students at [The American University of Iraq, Sulaimani (AUIS)](https://auis.edu.krd/) and follows the GPA calculation policy outlined in [How to Calculate Your GPA](https://auis.edu.krd/how-calculate-your-gpa).


## Features

- GPA calculator for UG and MBA students
- Accurate GPA & CGPA calculation based on AUIS rules
- Automatic saving and loading of courses and CGPA
- Dark mode and responsive design for desktop & mobile
- Web and Android support

## UG vs MBA GPA Rules

- **UG**: Uses custom credit hours and full grade scale (A to F)
- **MBA**: Fixed 2-credit courses with limited grade range (A to C, F)


## Try It Online or Download

- **Web**: [Launch Web App](https://mllrr96.github.io/Gpa-Calculator/)
- **Android**:
  
  [<img src="https://github.com/user-attachments/assets/a50513b3-dbf8-48c1-bff8-1f4215fefbb9"
alt="Get it on GitHub"
height="80">](https://github.com/mllrr96/Gpa-Calculator/releases)


##  Screenshots

<table>
  <tr>
    <th>Home Screen</th>
    <th>Grade Entry</th>
    <th>GPA Result</th>
  </tr>
  <tr>
    <td><img src="https://github.com/mllrr96/gpa_calculator/blob/main/screenshots/Home-Empty.png" width="400"/></td>
    <td><img src="https://github.com/mllrr96/gpa_calculator/blob/main/screenshots/Home.png" width="400"/></td>
    <td><img src="https://github.com/mllrr96/gpa_calculator/blob/main/screenshots/Result.png" width="400"/></td>
  </tr>
</table>

## Build from Source

### Clone the repository to your local machine
```bash
git clone https://github.com/mllrr96/gpa_calculator.git
```

### Move into the project directory
```bash
cd gpa_calculator
```

### Install all the required Flutter packages
```bash
flutter pub get
```

### Run the app on your connected device or emulator
```bash
flutter run
```
