/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.android.apps.mytracks.services.tasks;

import android.content.Context;

/**
 * An interface for classes that can create periodic tasks.
 *
 * @author Sandor Dornbush
 */
public interface PeriodicTaskFactory {

  /**
   * Creates a periodic task which does voice announcements.
   *
   * @return the task, or null if task is not supported
   */
  PeriodicTask create(Context context);
}