/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.google.android.apps.analytics.CustomVariable;
import com.google.android.apps.analytics.CustomVariableBuffer;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.EventStore;
import com.google.android.apps.analytics.Item;
import com.google.android.apps.analytics.Transaction;
import java.security.SecureRandom;
import java.util.ArrayList;

class PersistentEventStore
implements EventStore {
    private static final int MAX_EVENTS = 1000;
    private static final String STORE_ID = "store_id";
    private static final String EVENT_ID = "event_id";
    private static final String SCREEN_WIDTH = "screen_width";
    private static final String SCREEN_HEIGHT = "screen_height";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String ACTION = "action";
    private static final String CATEGORY = "category";
    private static final String VISITS = "visits";
    private static final String TIMESTAMP_CURRENT = "timestamp_current";
    private static final String TIMESTAMP_PREVIOUS = "timestamp_previous";
    private static final String TIMESTAMP_FIRST = "timestamp_first";
    private static final String RANDOM_VAL = "random_val";
    private static final String ACCOUNT_ID = "account_id";
    private static final String USER_ID = "user_id";
    private static final String REFERRER = "referrer";
    private static final String CUSTOMVAR_ID = "cv_id";
    private static final String CUSTOMVAR_INDEX = "cv_index";
    private static final String CUSTOMVAR_NAME = "cv_name";
    private static final String CUSTOMVAR_VALUE = "cv_value";
    private static final String CUSTOMVAR_SCOPE = "cv_scope";
    private static final String CUSTOM_VARIABLE_COLUMN_TYPE = "CHAR(64) NOT NULL";
    private static final String TRANSACTION_ID = "tran_id";
    private static final String ORDER_ID = "order_id";
    private static final String STORE_NAME = "tran_storename";
    private static final String TOTAL_COST = "tran_totalcost";
    private static final String TOTAL_TAX = "tran_totaltax";
    private static final String SHIPPING_COST = "tran_shippingcost";
    private static final String ITEM_ID = "item_id";
    private static final String ITEM_SKU = "item_sku";
    private static final String ITEM_NAME = "item_name";
    private static final String ITEM_CATEGORY = "item_category";
    private static final String ITEM_PRICE = "item_price";
    private static final String ITEM_COUNT = "item_count";
    private static final String DATABASE_NAME = "google_analytics.db";
    private static final int DATABASE_VERSION = 3;
    private DataBaseHelper databaseHelper;
    private int storeId;
    private long timestampFirst;
    private long timestampPrevious;
    private long timestampCurrent;
    private int visits;
    private int numStoredEvents;
    private boolean sessionUpdated;
    private boolean useStoredVisitorVars;
    private SQLiteStatement compiledCountStatement = null;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "user_id") + String.format(" '%s' CHAR(256) NOT NULL,", "account_id") + String.format(" '%s' INTEGER NOT NULL,", "random_val") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_first") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_previous") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_current") + String.format(" '%s' INTEGER NOT NULL,", "visits") + String.format(" '%s' CHAR(256) NOT NULL,", "category") + String.format(" '%s' CHAR(256) NOT NULL,", "action") + String.format(" '%s' CHAR(256), ", "label") + String.format(" '%s' INTEGER,", "value") + String.format(" '%s' INTEGER,", "screen_width") + String.format(" '%s' INTEGER);", "screen_height");
    private static final String CREATE_SESSION_TABLE = "CREATE TABLE session (" + String.format(" '%s' INTEGER PRIMARY KEY,", "timestamp_first") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_previous") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_current") + String.format(" '%s' INTEGER NOT NULL,", "visits") + String.format(" '%s' INTEGER NOT NULL);", "store_id");
    private static final String CREATE_INSTALL_REFERRER_TABLE = "CREATE TABLE install_referrer (referrer TEXT PRIMARY KEY NOT NULL);";
    private static final String CREATE_CUSTOM_VARIABLES_TABLE = "CREATE TABLE custom_variables (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "cv_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "cv_index") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_name") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_value") + String.format(" '%s' INTEGER NOT NULL);", "cv_scope");
    private static final String CREATE_CUSTOM_VAR_CACHE_TABLE = "CREATE TABLE custom_var_cache (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "cv_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "cv_index") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_name") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_value") + String.format(" '%s' INTEGER NOT NULL);", "cv_scope");
    private static final String CREATE_TRANSACTION_EVENTS_TABLE = "CREATE TABLE transaction_events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "tran_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' TEXT NOT NULL,", "order_id") + String.format(" '%s' TEXT,", "tran_storename") + String.format(" '%s' TEXT NOT NULL,", "tran_totalcost") + String.format(" '%s' TEXT,", "tran_totaltax") + String.format(" '%s' TEXT);", "tran_shippingcost");
    private static final String CREATE_ITEM_EVENTS_TABLE = "CREATE TABLE item_events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "item_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' TEXT NOT NULL,", "order_id") + String.format(" '%s' TEXT NOT NULL,", "item_sku") + String.format(" '%s' TEXT,", "item_name") + String.format(" '%s' TEXT,", "item_category") + String.format(" '%s' TEXT NOT NULL,", "item_price") + String.format(" '%s' TEXT NOT NULL);", "item_count");

    PersistentEventStore(DataBaseHelper dataBaseHelper) {
        this.databaseHelper = dataBaseHelper;
        try {
            dataBaseHelper.getWritableDatabase().close();
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    public void deleteEvent(long l) {
        String string = "event_id=" + l;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            if (sQLiteDatabase.delete("events", string, null) != 0) {
                --this.numStoredEvents;
                sQLiteDatabase.delete("custom_variables", string, null);
                sQLiteDatabase.delete("transaction_events", string, null);
                sQLiteDatabase.delete("item_events", string, null);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    public Event[] peekEvents() {
        return this.peekEvents(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event[] peekEvents(int n) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("events", null, null, null, null, null, EVENT_ID, Integer.toString(n));
            while (cursor.moveToNext()) {
                Object object;
                Event event = new Event(cursor.getLong(0), cursor.getInt(1), cursor.getString(2), cursor.getInt(3), cursor.getInt(4), cursor.getInt(5), cursor.getInt(6), cursor.getInt(7), cursor.getString(8), cursor.getString(9), cursor.getString(10), cursor.getInt(11), cursor.getInt(12), cursor.getInt(13));
                long l = cursor.getLong(cursor.getColumnIndex(EVENT_ID));
                if ("__##GOOGLETRANSACTION##__".equals(event.category)) {
                    object = this.getTransaction(l);
                    if (object == null) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)("missing expected transaction for event " + l));
                    }
                    event.setTransaction((Transaction)object);
                } else if ("__##GOOGLEITEM##__".equals(event.category)) {
                    object = this.getItem(l);
                    if (object == null) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)("missing expected item for event " + l));
                    }
                    event.setItem((Item)object);
                } else {
                    object = this.getCustomVariables(l);
                    event.setCustomVariableBuffer((CustomVariableBuffer)object);
                }
                arrayList.add(event);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            Event[] eventArray = new Event[]{};
            return eventArray;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList.toArray(new Event[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transaction getTransaction(long l) {
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("transaction_events", null, "event_id=" + l, null, null, null, null);
            if (cursor.moveToFirst()) {
                Transaction transaction = new Transaction.Builder(cursor.getString(cursor.getColumnIndex(ORDER_ID)), cursor.getDouble(cursor.getColumnIndex(TOTAL_COST))).setStoreName(cursor.getString(cursor.getColumnIndex(STORE_NAME))).setTotalTax(cursor.getDouble(cursor.getColumnIndex(TOTAL_TAX))).setShippingCost(cursor.getDouble(cursor.getColumnIndex(SHIPPING_COST))).build();
                return transaction;
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Item getItem(long l) {
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("item_events", null, "event_id=" + l, null, null, null, null);
            if (cursor.moveToFirst()) {
                Item item = new Item.Builder(cursor.getString(cursor.getColumnIndex(ORDER_ID)), cursor.getString(cursor.getColumnIndex(ITEM_SKU)), cursor.getDouble(cursor.getColumnIndex(ITEM_PRICE)), cursor.getLong(cursor.getColumnIndex(ITEM_COUNT))).setItemName(cursor.getString(cursor.getColumnIndex(ITEM_NAME))).setItemCategory(cursor.getString(cursor.getColumnIndex(ITEM_CATEGORY))).build();
                return item;
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomVariableBuffer getCustomVariables(long l) {
        Cursor cursor = null;
        CustomVariableBuffer customVariableBuffer = new CustomVariableBuffer();
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("custom_variables", null, "event_id=" + l, null, null, null, null);
            while (cursor.moveToNext()) {
                CustomVariable customVariable = new CustomVariable(cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_INDEX)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_NAME)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE)), cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_SCOPE)));
                customVariableBuffer.setCustomVariable(customVariable);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return customVariableBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorCustomVar(int n) {
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("custom_var_cache", null, "cv_scope = 1 AND cv_index = " + n, null, null, null, null);
            String string = null;
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                string = cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE));
            } else {
                string = null;
            }
            sQLiteDatabase.close();
            String string2 = string;
            return string2;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            String string = null;
            return string;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEvent(Event event) {
        if (this.numStoredEvents >= 1000) {
            Log.w((String)"GoogleAnalyticsTracker", (String)"Store full. Not storing last event.");
            return;
        }
        if (!this.sessionUpdated) {
            this.storeUpdatedSession();
        }
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            ContentValues contentValues = new ContentValues();
            contentValues.put(USER_ID, Integer.valueOf(event.userId));
            contentValues.put(ACCOUNT_ID, event.accountId);
            contentValues.put(RANDOM_VAL, Integer.valueOf((int)(Math.random() * 2.147483647E9)));
            contentValues.put(TIMESTAMP_FIRST, Long.valueOf(this.timestampFirst));
            contentValues.put(TIMESTAMP_PREVIOUS, Long.valueOf(this.timestampPrevious));
            contentValues.put(TIMESTAMP_CURRENT, Long.valueOf(this.timestampCurrent));
            contentValues.put(VISITS, Integer.valueOf(this.visits));
            contentValues.put(CATEGORY, event.category);
            contentValues.put(ACTION, event.action);
            contentValues.put(LABEL, event.label);
            contentValues.put(VALUE, Integer.valueOf(event.value));
            contentValues.put(SCREEN_WIDTH, Integer.valueOf(event.screenWidth));
            contentValues.put(SCREEN_HEIGHT, Integer.valueOf(event.screenHeight));
            long l = sQLiteDatabase.insert("events", EVENT_ID, contentValues);
            if (l != -1L) {
                ++this.numStoredEvents;
                Cursor cursor = sQLiteDatabase.query("events", new String[]{EVENT_ID}, null, null, null, null, "event_id DESC", null);
                cursor.moveToPosition(0);
                long l2 = cursor.getLong(0);
                cursor.close();
                if (event.category.equals("__##GOOGLETRANSACTION##__")) {
                    this.putTransaction(event, l2);
                } else if (event.category.equals("__##GOOGLEITEM##__")) {
                    this.putItem(event, l2);
                } else {
                    this.putCustomVariables(event, l2);
                }
                sQLiteDatabase.setTransactionSuccessful();
            } else {
                Log.e((String)"GoogleAnalyticsTracker", (String)"Error when attempting to add event to database.");
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (sQLiteDatabase != null) {
                sQLiteDatabase.endTransaction();
            }
        }
    }

    void putTransaction(Event event, long l) {
        Transaction transaction = event.getTransaction();
        if (transaction == null) {
            Log.w((String)"GoogleAnalyticsTracker", (String)("missing transaction details for event " + l));
            return;
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(EVENT_ID, Long.valueOf(l));
            contentValues.put(ORDER_ID, transaction.getOrderId());
            contentValues.put(STORE_NAME, transaction.getStoreName());
            contentValues.put(TOTAL_COST, transaction.getTotalCost() + "");
            contentValues.put(TOTAL_TAX, transaction.getTotalTax() + "");
            contentValues.put(SHIPPING_COST, transaction.getShippingCost() + "");
            sQLiteDatabase.insert("transaction_events", EVENT_ID, contentValues);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    void putItem(Event event, long l) {
        Item item = event.getItem();
        if (item == null) {
            Log.w((String)"GoogleAnalyticsTracker", (String)("missing item details for event " + l));
            return;
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(EVENT_ID, Long.valueOf(l));
            contentValues.put(ORDER_ID, item.getOrderId());
            contentValues.put(ITEM_SKU, item.getItemSKU());
            contentValues.put(ITEM_NAME, item.getItemName());
            contentValues.put(ITEM_CATEGORY, item.getItemCategory());
            contentValues.put(ITEM_PRICE, item.getItemPrice() + "");
            contentValues.put(ITEM_COUNT, item.getItemCount() + "");
            sQLiteDatabase.insert("item_events", EVENT_ID, contentValues);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    void putCustomVariables(Event event, long l) {
        try {
            CustomVariable customVariable;
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            CustomVariableBuffer customVariableBuffer = event.getCustomVariableBuffer();
            if (this.useStoredVisitorVars) {
                if (customVariableBuffer == null) {
                    customVariableBuffer = new CustomVariableBuffer();
                    event.setCustomVariableBuffer(customVariableBuffer);
                }
                CustomVariableBuffer customVariableBuffer2 = this.getVisitorVarBuffer();
                for (int i = 1; i <= 5; ++i) {
                    customVariable = customVariableBuffer2.getCustomVariableAt(i);
                    CustomVariable customVariable2 = customVariableBuffer.getCustomVariableAt(i);
                    if (customVariable == null || customVariable2 != null) continue;
                    customVariableBuffer.setCustomVariable(customVariable);
                }
                this.useStoredVisitorVars = false;
            }
            if (customVariableBuffer != null) {
                for (int i = 1; i <= 5; ++i) {
                    if (customVariableBuffer.isIndexAvailable(i)) continue;
                    CustomVariable customVariable3 = customVariableBuffer.getCustomVariableAt(i);
                    customVariable = new ContentValues();
                    customVariable.put(EVENT_ID, l);
                    customVariable.put(CUSTOMVAR_INDEX, customVariable3.getIndex());
                    customVariable.put(CUSTOMVAR_NAME, customVariable3.getName());
                    customVariable.put(CUSTOMVAR_SCOPE, customVariable3.getScope());
                    customVariable.put(CUSTOMVAR_VALUE, customVariable3.getValue());
                    sQLiteDatabase.insert("custom_variables", EVENT_ID, (ContentValues)customVariable);
                    sQLiteDatabase.update("custom_var_cache", (ContentValues)customVariable, "cv_index=" + customVariable3.getIndex(), null);
                }
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    CustomVariableBuffer getVisitorVarBuffer() {
        CustomVariableBuffer customVariableBuffer = new CustomVariableBuffer();
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            Cursor cursor = sQLiteDatabase.query("custom_var_cache", null, "cv_scope=1", null, null, null, null);
            while (cursor.moveToNext()) {
                CustomVariable customVariable = new CustomVariable(cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_INDEX)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_NAME)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE)), cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_SCOPE)));
                customVariableBuffer.setCustomVariable(customVariable);
            }
            cursor.close();
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        return customVariableBuffer;
    }

    public int getNumStoredEvents() {
        try {
            if (this.compiledCountStatement == null) {
                this.compiledCountStatement = this.databaseHelper.getReadableDatabase().compileStatement("SELECT COUNT(*) from events");
            }
            return (int)this.compiledCountStatement.simpleQueryForLong();
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            return 0;
        }
    }

    public int getStoreId() {
        return this.storeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewVisit() {
        this.sessionUpdated = false;
        this.useStoredVisitorVars = true;
        this.numStoredEvents = this.getNumStoredEvents();
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            cursor = sQLiteDatabase.query("session", null, null, null, null, null, null);
            if (!cursor.moveToFirst()) {
                long l;
                this.timestampFirst = l = System.currentTimeMillis() / 1000L;
                this.timestampPrevious = l;
                this.timestampCurrent = l;
                this.visits = 1;
                this.storeId = new SecureRandom().nextInt() & Integer.MAX_VALUE;
                ContentValues contentValues = new ContentValues();
                contentValues.put(TIMESTAMP_FIRST, Long.valueOf(this.timestampFirst));
                contentValues.put(TIMESTAMP_PREVIOUS, Long.valueOf(this.timestampPrevious));
                contentValues.put(TIMESTAMP_CURRENT, Long.valueOf(this.timestampCurrent));
                contentValues.put(VISITS, Integer.valueOf(this.visits));
                contentValues.put(STORE_ID, Integer.valueOf(this.storeId));
                sQLiteDatabase.insert("session", TIMESTAMP_FIRST, contentValues);
            } else {
                this.timestampFirst = cursor.getLong(0);
                this.timestampPrevious = cursor.getLong(2);
                this.timestampCurrent = System.currentTimeMillis() / 1000L;
                this.visits = cursor.getInt(3) + 1;
                this.storeId = cursor.getInt(4);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    void storeUpdatedSession() {
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(TIMESTAMP_PREVIOUS, Long.valueOf(this.timestampPrevious));
            contentValues.put(TIMESTAMP_CURRENT, Long.valueOf(this.timestampCurrent));
            contentValues.put(VISITS, Integer.valueOf(this.visits));
            sQLiteDatabase.update("session", contentValues, "timestamp_first=?", new String[]{Long.toString(this.timestampFirst)});
            this.sessionUpdated = true;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    public void setReferrer(String string) {
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(REFERRER, string);
            sQLiteDatabase.insert("install_referrer", null, contentValues);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReferrer() {
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("install_referrer", new String[]{REFERRER}, null, null, null, null, null);
            String string = null;
            if (cursor.moveToFirst()) {
                string = cursor.getString(0);
            }
            String string2 = string;
            return string2;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            String string = null;
            return string;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    static class DataBaseHelper
    extends SQLiteOpenHelper {
        private final int databaseVersion;

        public DataBaseHelper(Context context) {
            this(context, PersistentEventStore.DATABASE_NAME, 3);
        }

        public DataBaseHelper(Context context, String string) {
            this(context, string, 3);
        }

        DataBaseHelper(Context context, String string, int n) {
            super(context, string, null, n);
            this.databaseVersion = n;
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS events;");
            sQLiteDatabase.execSQL(CREATE_EVENTS_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS session;");
            sQLiteDatabase.execSQL(CREATE_SESSION_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS install_referrer;");
            sQLiteDatabase.execSQL(PersistentEventStore.CREATE_INSTALL_REFERRER_TABLE);
            if (this.databaseVersion > 1) {
                this.createCustomVariableTables(sQLiteDatabase);
            }
            if (this.databaseVersion > 2) {
                this.createECommerceTables(sQLiteDatabase);
            }
        }

        void createCustomVariableTables(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS custom_variables;");
            sQLiteDatabase.execSQL(CREATE_CUSTOM_VARIABLES_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS custom_var_cache;");
            sQLiteDatabase.execSQL(CREATE_CUSTOM_VAR_CACHE_TABLE);
            for (int i = 1; i <= 5; ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(PersistentEventStore.EVENT_ID, Integer.valueOf(0));
                contentValues.put(PersistentEventStore.CUSTOMVAR_INDEX, Integer.valueOf(i));
                contentValues.put(PersistentEventStore.CUSTOMVAR_NAME, "");
                contentValues.put(PersistentEventStore.CUSTOMVAR_SCOPE, Integer.valueOf(3));
                contentValues.put(PersistentEventStore.CUSTOMVAR_VALUE, "");
                sQLiteDatabase.insert("custom_var_cache", PersistentEventStore.EVENT_ID, contentValues);
            }
        }

        private void createECommerceTables(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS transaction_events;");
            sQLiteDatabase.execSQL(CREATE_TRANSACTION_EVENTS_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS item_events;");
            sQLiteDatabase.execSQL(CREATE_ITEM_EVENTS_TABLE);
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            if (n < 2 && n2 > 1) {
                this.createCustomVariableTables(sQLiteDatabase);
            }
            if (n < 3 && n2 > 2) {
                this.createECommerceTables(sQLiteDatabase);
            }
        }

        public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.w((String)"GoogleAnalyticsTracker", (String)("Downgrading database version from " + n + " to " + n2 + " not recommended."));
        }
    }
}

