/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import com.google.android.apps.analytics.AnalyticsParameterEncoder;
import com.google.android.apps.analytics.CustomVariable;
import com.google.android.apps.analytics.CustomVariableBuffer;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.Item;
import com.google.android.apps.analytics.Transaction;
import java.util.Locale;

class NetworkRequestUtil {
    private static final String GOOGLE_ANALYTICS_GIF_PATH = "/__utm.gif";
    private static final String FAKE_DOMAIN_HASH = "999";
    private static final int X10_PROJECT_NAMES = 8;
    private static final int X10_PROJECT_VALUES = 9;
    private static final int X10_PROJECT_SCOPES = 11;

    NetworkRequestUtil() {
    }

    public static String constructPageviewRequestPath(Event event, String string) {
        String string2 = "";
        if (event.action != null) {
            string2 = event.action;
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        string2 = NetworkRequestUtil.encode(string2);
        String string3 = NetworkRequestUtil.getCustomVariableParams(event);
        Locale locale = Locale.getDefault();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.6ma");
        stringBuilder.append("&utmn=").append(event.randomVal);
        if (string3.length() > 0) {
            stringBuilder.append("&utme=").append(string3);
        }
        stringBuilder.append("&utmcs=UTF-8");
        stringBuilder.append(String.format("&utmsr=%dx%d", event.screenWidth, event.screenHeight));
        stringBuilder.append(String.format("&utmul=%s-%s", locale.getLanguage(), locale.getCountry()));
        stringBuilder.append("&utmp=").append(string2);
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(NetworkRequestUtil.getEscapedCookieString(event, string));
        return stringBuilder.toString();
    }

    public static String constructEventRequestPath(Event event, String string) {
        Locale locale = Locale.getDefault();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(String.format("5(%s*%s", NetworkRequestUtil.encode(event.category), NetworkRequestUtil.encode(event.action)));
        if (event.label != null) {
            stringBuilder2.append("*").append(NetworkRequestUtil.encode(event.label));
        }
        stringBuilder2.append(")");
        if (event.value > -1) {
            stringBuilder2.append(String.format("(%d)", event.value));
        }
        stringBuilder2.append(NetworkRequestUtil.getCustomVariableParams(event));
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.6ma");
        stringBuilder.append("&utmn=").append(event.randomVal);
        stringBuilder.append("&utmt=event");
        stringBuilder.append("&utme=").append(stringBuilder2.toString());
        stringBuilder.append("&utmcs=UTF-8");
        stringBuilder.append(String.format("&utmsr=%dx%d", event.screenWidth, event.screenHeight));
        stringBuilder.append(String.format("&utmul=%s-%s", locale.getLanguage(), locale.getCountry()));
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(NetworkRequestUtil.getEscapedCookieString(event, string));
        return stringBuilder.toString();
    }

    private static void appendStringValue(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append("=");
        if (string2 != null && string2.trim().length() > 0) {
            stringBuilder.append(AnalyticsParameterEncoder.encode(string2));
        }
    }

    static void appendCurrencyValue(StringBuilder stringBuilder, String string, double d) {
        stringBuilder.append(string).append("=");
        double d2 = Math.floor(d * 1000000.0 + 0.5) / 1000000.0;
        if (d2 != 0.0) {
            stringBuilder.append(Double.toString(d2));
        }
    }

    public static String constructTransactionRequestPath(Event event, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.6ma");
        stringBuilder.append("&utmn=").append(event.randomVal);
        stringBuilder.append("&utmt=tran");
        Transaction transaction = event.getTransaction();
        if (transaction != null) {
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtid", transaction.getOrderId());
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtst", transaction.getStoreName());
            NetworkRequestUtil.appendCurrencyValue(stringBuilder, "&utmtto", transaction.getTotalCost());
            NetworkRequestUtil.appendCurrencyValue(stringBuilder, "&utmttx", transaction.getTotalTax());
            NetworkRequestUtil.appendCurrencyValue(stringBuilder, "&utmtsp", transaction.getShippingCost());
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtci", "");
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtrg", "");
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtco", "");
        }
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(NetworkRequestUtil.getEscapedCookieString(event, string));
        return stringBuilder.toString();
    }

    public static String constructItemRequestPath(Event event, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.6ma");
        stringBuilder.append("&utmn=").append(event.randomVal);
        stringBuilder.append("&utmt=item");
        Item item = event.getItem();
        if (item != null) {
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmtid", item.getOrderId());
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmipc", item.getItemSKU());
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmipn", item.getItemName());
            NetworkRequestUtil.appendStringValue(stringBuilder, "&utmiva", item.getItemCategory());
            NetworkRequestUtil.appendCurrencyValue(stringBuilder, "&utmipr", item.getItemPrice());
            stringBuilder.append("&utmiqt=");
            if (item.getItemCount() != 0L) {
                stringBuilder.append(item.getItemCount());
            }
        }
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(NetworkRequestUtil.getEscapedCookieString(event, string));
        return stringBuilder.toString();
    }

    public static String getCustomVariableParams(Event event) {
        StringBuilder stringBuilder = new StringBuilder();
        CustomVariableBuffer customVariableBuffer = event.getCustomVariableBuffer();
        if (customVariableBuffer == null) {
            return "";
        }
        if (!customVariableBuffer.hasCustomVariables()) {
            return "";
        }
        CustomVariable[] customVariableArray = customVariableBuffer.getCustomVariableArray();
        NetworkRequestUtil.createX10Project(customVariableArray, stringBuilder, 8);
        NetworkRequestUtil.createX10Project(customVariableArray, stringBuilder, 9);
        NetworkRequestUtil.createX10Project(customVariableArray, stringBuilder, 11);
        return stringBuilder.toString();
    }

    private static void createX10Project(CustomVariable[] customVariableArray, StringBuilder stringBuilder, int n) {
        boolean bl = true;
        stringBuilder.append(n).append("(");
        block5: for (int i = 0; i < customVariableArray.length; ++i) {
            if (customVariableArray[i] == null) continue;
            CustomVariable customVariable = customVariableArray[i];
            if (!bl) {
                stringBuilder.append("*");
            } else {
                bl = false;
            }
            stringBuilder.append(customVariable.getIndex()).append("!");
            switch (n) {
                case 8: {
                    stringBuilder.append(NetworkRequestUtil.x10Escape(NetworkRequestUtil.encode(customVariable.getName())));
                    continue block5;
                }
                case 9: {
                    stringBuilder.append(NetworkRequestUtil.x10Escape(NetworkRequestUtil.encode(customVariable.getValue())));
                    continue block5;
                }
                case 11: {
                    stringBuilder.append(customVariable.getScope());
                }
            }
        }
        stringBuilder.append(")");
    }

    private static String x10Escape(String string) {
        return string.replace("'", "'0").replace(")", "'1").replace("*", "'2").replace("!", "'3");
    }

    public static String getEscapedCookieString(Event event, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("__utma=");
        stringBuilder.append(FAKE_DOMAIN_HASH).append(".");
        stringBuilder.append(event.userId).append(".");
        stringBuilder.append(event.timestampFirst).append(".");
        stringBuilder.append(event.timestampPrevious).append(".");
        stringBuilder.append(event.timestampCurrent).append(".");
        stringBuilder.append(event.visits);
        if (string != null) {
            stringBuilder.append("+__utmz=");
            stringBuilder.append(FAKE_DOMAIN_HASH).append(".");
            stringBuilder.append(event.timestampFirst).append(".");
            stringBuilder.append("1.1.");
            stringBuilder.append(string);
        }
        return NetworkRequestUtil.encode(stringBuilder.toString());
    }

    private static String encode(String string) {
        return AnalyticsParameterEncoder.encode(string);
    }
}

