/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.util.Log;
import com.google.android.apps.analytics.CustomVariable;
import com.google.android.apps.analytics.CustomVariableBuffer;
import com.google.android.apps.analytics.Dispatcher;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.EventStore;
import com.google.android.apps.analytics.Item;
import com.google.android.apps.analytics.NetworkDispatcher;
import com.google.android.apps.analytics.PersistentEventStore;
import com.google.android.apps.analytics.Transaction;
import java.util.HashMap;
import java.util.Map;

public class GoogleAnalyticsTracker {
    public static final String PRODUCT = "GoogleAnalytics";
    public static final String VERSION = "1.2";
    public static final String WIRE_VERSION = "4.6ma";
    private static final GoogleAnalyticsTracker INSTANCE = new GoogleAnalyticsTracker();
    public static final String LOG_TAG = "GoogleAnalyticsTracker";
    private boolean debug = false;
    private boolean dryRun = false;
    private String accountId;
    private Context parent;
    private ConnectivityManager connetivityManager;
    private String userAgentProduct = "GoogleAnalytics";
    private String userAgentVersion = "1.2";
    private int dispatchPeriod;
    private EventStore eventStore;
    private Dispatcher dispatcher;
    private boolean powerSaveMode;
    private boolean dispatcherIsBusy;
    private CustomVariableBuffer customVariableBuffer;
    private Map<String, Transaction> transactionMap = new HashMap<String, Transaction>();
    private Map<String, Map<String, Item>> itemMap = new HashMap<String, Map<String, Item>>();
    private Handler handler;
    private Runnable dispatchRunner = new Runnable(){

        public void run() {
            GoogleAnalyticsTracker.this.dispatch();
        }
    };

    private GoogleAnalyticsTracker() {
    }

    public static GoogleAnalyticsTracker getInstance() {
        return INSTANCE;
    }

    public void start(String string, int n, Context context) {
        EventStore eventStore = null;
        Dispatcher dispatcher = null;
        eventStore = this.eventStore == null ? new PersistentEventStore(new PersistentEventStore.DataBaseHelper(context)) : this.eventStore;
        if (this.dispatcher == null) {
            dispatcher = new NetworkDispatcher(this.userAgentProduct, this.userAgentVersion);
            dispatcher.setDryRun(this.dryRun);
        } else {
            dispatcher = this.dispatcher;
        }
        this.start(string, n, context, eventStore, dispatcher);
    }

    public void start(String string, Context context) {
        this.start(string, -1, context);
    }

    void start(String string, int n, Context context, EventStore eventStore, Dispatcher dispatcher) {
        this.start(string, n, context, eventStore, dispatcher, new DispatcherCallbacks());
    }

    void start(String string, int n, Context context, EventStore eventStore, Dispatcher dispatcher, Dispatcher.Callbacks callbacks) {
        this.accountId = string;
        this.parent = context;
        this.eventStore = eventStore;
        this.eventStore.startNewVisit();
        this.dispatcher = dispatcher;
        this.dispatcher.init(callbacks, this.eventStore.getReferrer());
        this.dispatcherIsBusy = false;
        if (this.connetivityManager == null) {
            this.connetivityManager = (ConnectivityManager)this.parent.getSystemService("connectivity");
        }
        if (this.handler == null) {
            this.handler = new Handler(context.getMainLooper());
        } else {
            this.cancelPendingDispatches();
        }
        this.setDispatchPeriod(n);
    }

    Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setProductVersion(String string, String string2) {
        this.userAgentProduct = string;
        this.userAgentVersion = string2;
    }

    public void trackEvent(String string, String string2, String string3, int n) {
        this.createEvent(this.accountId, string, string2, string3, n);
    }

    public void trackPageView(String string) {
        this.createEvent(this.accountId, "__##GOOGLEPAGEVIEW##__", string, null, -1);
    }

    private void createEvent(String string, String string2, String string3, String string4, int n) {
        Event event = new Event(this.eventStore.getStoreId(), string, string2, string3, string4, n, this.parent.getResources().getDisplayMetrics().widthPixels, this.parent.getResources().getDisplayMetrics().heightPixels);
        event.setCustomVariableBuffer(this.customVariableBuffer);
        this.customVariableBuffer = new CustomVariableBuffer();
        this.eventStore.putEvent(event);
        this.resetPowerSaveMode();
    }

    public void setDispatchPeriod(int n) {
        int n2 = this.dispatchPeriod;
        this.dispatchPeriod = n;
        if (n2 <= 0) {
            this.maybeScheduleNextDispatch();
        } else if (n2 > 0) {
            this.cancelPendingDispatches();
            this.maybeScheduleNextDispatch();
        }
    }

    private void maybeScheduleNextDispatch() {
        if (this.dispatchPeriod < 0) {
            return;
        }
        if (this.handler.postDelayed(this.dispatchRunner, (long)(this.dispatchPeriod * 1000)) && this.debug) {
            Log.v((String)LOG_TAG, (String)"Scheduled next dispatch");
        }
    }

    private void cancelPendingDispatches() {
        this.handler.removeCallbacks(this.dispatchRunner);
    }

    private void resetPowerSaveMode() {
        if (this.powerSaveMode) {
            this.powerSaveMode = false;
            this.maybeScheduleNextDispatch();
        }
    }

    public boolean dispatch() {
        if (this.debug) {
            Log.v((String)LOG_TAG, (String)"Called dispatch");
        }
        if (this.dispatcherIsBusy) {
            if (this.debug) {
                Log.v((String)LOG_TAG, (String)"...but dispatcher was busy");
            }
            this.maybeScheduleNextDispatch();
            return false;
        }
        NetworkInfo networkInfo = this.connetivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isAvailable()) {
            if (this.debug) {
                Log.v((String)LOG_TAG, (String)"...but there was no network available");
            }
            this.maybeScheduleNextDispatch();
            return false;
        }
        if (this.eventStore.getNumStoredEvents() != 0) {
            Event[] eventArray = this.eventStore.peekEvents();
            this.dispatcher.dispatchEvents(eventArray);
            this.dispatcherIsBusy = true;
            this.maybeScheduleNextDispatch();
            if (this.debug) {
                Log.v((String)LOG_TAG, (String)("Sending " + eventArray.length + " to dispatcher"));
            }
            return true;
        }
        this.powerSaveMode = true;
        if (this.debug) {
            Log.v((String)LOG_TAG, (String)"...but there was nothing to dispatch");
        }
        return false;
    }

    void dispatchFinished() {
        this.dispatcherIsBusy = false;
    }

    public void stop() {
        this.dispatcher.stop();
        this.cancelPendingDispatches();
    }

    EventStore getEventStore() {
        return this.eventStore;
    }

    public boolean setCustomVar(int n, String string, String string2, int n2) {
        try {
            CustomVariable customVariable = new CustomVariable(n, string, string2, n2);
            if (this.customVariableBuffer == null) {
                this.customVariableBuffer = new CustomVariableBuffer();
            }
            this.customVariableBuffer.setCustomVariable(customVariable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean setCustomVar(int n, String string, String string2) {
        return this.setCustomVar(n, string, string2, 3);
    }

    public String getVisitorCustomVar(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("Index must be between 1 and 5 inclusive.");
        }
        return this.eventStore.getVisitorCustomVar(n);
    }

    public void addTransaction(Transaction transaction) {
        this.transactionMap.put(transaction.getOrderId(), transaction);
    }

    public void addItem(Item item) {
        Map<String, Item> map;
        Transaction transaction = this.transactionMap.get(item.getOrderId());
        if (transaction == null) {
            Log.i((String)LOG_TAG, (String)("No transaction with orderId " + item.getOrderId() + " found, creating one"));
            transaction = new Transaction.Builder(item.getOrderId(), 0.0).build();
            this.transactionMap.put(item.getOrderId(), transaction);
        }
        if ((map = this.itemMap.get(item.getOrderId())) == null) {
            map = new HashMap<String, Item>();
            this.itemMap.put(item.getOrderId(), map);
        }
        map.put(item.getItemSKU(), item);
    }

    public void trackTransactions() {
        for (Transaction transaction : this.transactionMap.values()) {
            Event event = new Event(this.eventStore.getStoreId(), this.accountId, "__##GOOGLETRANSACTION##__", "", "", 0, this.parent.getResources().getDisplayMetrics().widthPixels, this.parent.getResources().getDisplayMetrics().heightPixels);
            event.setTransaction(transaction);
            this.eventStore.putEvent(event);
            Map<String, Item> map = this.itemMap.get(transaction.getOrderId());
            if (map == null) continue;
            for (Item item : map.values()) {
                event = new Event(this.eventStore.getStoreId(), this.accountId, "__##GOOGLEITEM##__", "", "", 0, this.parent.getResources().getDisplayMetrics().widthPixels, this.parent.getResources().getDisplayMetrics().heightPixels);
                event.setItem(item);
                this.eventStore.putEvent(event);
            }
        }
        this.clearTransactions();
        this.resetPowerSaveMode();
    }

    public void clearTransactions() {
        this.transactionMap.clear();
        this.itemMap.clear();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDryRun(boolean bl) {
        this.dryRun = bl;
        if (this.dispatcher != null) {
            this.dispatcher.setDryRun(bl);
        }
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    final class DispatcherCallbacks
    implements Dispatcher.Callbacks {
        DispatcherCallbacks() {
        }

        public void dispatchFinished() {
            GoogleAnalyticsTracker.this.handler.post(new Runnable(){

                public void run() {
                    GoogleAnalyticsTracker.this.dispatchFinished();
                }
            });
        }

        public void eventDispatched(long l) {
            GoogleAnalyticsTracker.this.eventStore.deleteEvent(l);
        }
    }
}

