/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.parser.xml;

import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.Feed;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.data.XmlUtils;
import com.google.wireless.gdata2.data.batch.BatchInterrupted;
import com.google.wireless.gdata2.data.batch.BatchStatus;
import com.google.wireless.gdata2.data.batch.BatchUtils;
import com.google.wireless.gdata2.parser.GDataParser;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlNametable;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlGDataParser
implements GDataParser {
    public static final String NAMESPACE_ATOM_URI = "http://www.w3.org/2005/Atom";
    public static final String NAMESPACE_OPENSEARCH_URI = "http://a9.com/-/spec/opensearch/1.1/";
    public static final String NAMESPACE_GD = "gd";
    public static final String NAMESPACE_GD_URI = "http://schemas.google.com/g/2005";
    public static final String NAMESPACE_BATCH = "batch";
    public static final String NAMESPACE_BATCH_URI = "http://schemas.google.com/gdata/batch";
    private final InputStream is;
    private final XmlPullParser parser;
    private boolean isInBadState;
    private String fields;

    public XmlGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        this.is = is;
        this.parser = parser;
        if (!parser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces")) {
            throw new IllegalStateException("A XmlGDataParser needs to be constructed with a namespace aware XmlPullParser");
        }
        this.isInBadState = false;
        if (this.is != null) {
            try {
                this.parser.setInput(is, null);
            }
            catch (XmlPullParserException e) {
                throw new ParseException("Could not create XmlGDataParser", e);
            }
        }
    }

    public final Feed parseFeedEnvelope() throws ParseException {
        int eventType;
        this.fields = null;
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse GData feed.", e);
        }
        if (eventType != 0) {
            throw new ParseException("Attempting to initialize parsing beyond the start of the document.");
        }
        try {
            eventType = this.parser.next();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not read next event.", xppe);
        }
        catch (IOException ioe) {
            throw new ParseException("Could not read next event.", ioe);
        }
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (XmlNametable.PARTIAL.equals(name)) {
                        try {
                            return this.parsePartialFeed();
                        }
                        catch (XmlPullParserException xppe) {
                            throw new ParseException("Unable to parse <partial> feed start", xppe);
                        }
                        catch (IOException ioe) {
                            throw new ParseException("Unable to parse <partial> feed start", ioe);
                        }
                    }
                    if (!XmlNametable.FEED.equals(name)) break;
                    try {
                        return this.parseFeed();
                    }
                    catch (XmlPullParserException xppe) {
                        throw new ParseException("Unable to parse <feed>.", xppe);
                    }
                    catch (IOException ioe) {
                        throw new ParseException("Unable to parse <feed>.", ioe);
                    }
                }
            }
            try {
                eventType = this.parser.next();
            }
            catch (XmlPullParserException xppe) {
                throw new ParseException("Could not read next event.", xppe);
            }
            catch (IOException ioe) {
                throw new ParseException("Could not read next event.", ioe);
            }
        }
        throw new ParseException("No <feed> found in document.");
    }

    protected final XmlPullParser getParser() {
        return this.parser;
    }

    protected Feed createFeed() {
        return new Feed();
    }

    protected Entry createEntry() {
        return new Entry();
    }

    private final Feed parsePartialFeed() throws XmlPullParserException, IOException {
        this.fields = this.parser.getAttributeValue(null, XmlNametable.FIELDS);
        int eventType = this.parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    String namespace = this.parser.getNamespace();
                    if (!NAMESPACE_ATOM_URI.equals(namespace) || !XmlNametable.FEED.equals(name)) break;
                    return this.parseFeed();
                }
            }
            eventType = this.parser.next();
        }
        return null;
    }

    private final Feed parseFeed() throws XmlPullParserException, IOException {
        Feed feed = this.createFeed();
        feed.setETag(this.parser.getAttributeValue(NAMESPACE_GD_URI, XmlNametable.ETAG));
        int eventType = this.parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    String namespace = this.parser.getNamespace();
                    if (NAMESPACE_OPENSEARCH_URI.equals(namespace)) {
                        if (XmlNametable.TOTAL_RESULTS.equals(name)) {
                            feed.setTotalResults(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                            break;
                        }
                        if (XmlNametable.START_INDEX.equals(name)) {
                            feed.setStartIndex(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                            break;
                        }
                        if (!XmlNametable.ITEMS_PER_PAGE.equals(name)) break;
                        feed.setItemsPerPage(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                        break;
                    }
                    if (NAMESPACE_ATOM_URI.equals(namespace)) {
                        if (XmlNametable.TITLE.equals(name)) {
                            feed.setTitle(XmlUtils.extractChildText(this.parser));
                            break;
                        }
                        if (XmlNametable.ID.equals(name)) {
                            feed.setId(XmlUtils.extractChildText(this.parser));
                            break;
                        }
                        if (XmlNametable.UPDATED.equals(name)) {
                            feed.setLastUpdated(XmlUtils.extractChildText(this.parser));
                            break;
                        }
                        if (XmlNametable.CATEGORY.equals(name)) {
                            String categoryScheme;
                            String category = this.parser.getAttributeValue(null, XmlNametable.TERM);
                            if (!StringUtils.isEmpty(category)) {
                                feed.setCategory(category);
                            }
                            if (StringUtils.isEmpty(categoryScheme = this.parser.getAttributeValue(null, XmlNametable.SCHEME))) break;
                            feed.setCategoryScheme(categoryScheme);
                            break;
                        }
                        if (!XmlNametable.ENTRY.equals(name)) break;
                        return feed;
                    }
                    this.handleExtraElementInFeed(feed);
                }
            }
            eventType = this.parser.next();
        }
        return feed;
    }

    protected void handleExtraElementInFeed(Feed feed) throws XmlPullParserException, IOException {
    }

    public boolean hasMoreData() {
        if (this.isInBadState) {
            return false;
        }
        try {
            int eventType = this.parser.getEventType();
            return eventType != 1;
        }
        catch (XmlPullParserException xppe) {
            return false;
        }
    }

    public Entry readNextEntry(Entry entry) throws ParseException, IOException {
        int eventType;
        if (!this.hasMoreData()) {
            throw new IllegalStateException("you shouldn't call this if hasMoreData() is false");
        }
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse entry.", e);
        }
        if (eventType != 2) {
            throw new ParseException("Expected event START_TAG: Actual event: " + XmlPullParser.TYPES[eventType]);
        }
        String name = this.parser.getName();
        if (!XmlNametable.ENTRY.equals(name) && !XmlNametable.PARTIAL.equals(name)) {
            throw new ParseException("Expected <entry> or <partial>: Actual element: <" + name + ">");
        }
        if (entry == null) {
            entry = this.createEntry();
        } else {
            entry.clear();
        }
        try {
            if (XmlNametable.ENTRY.equals(name)) {
                this.handleEntry(entry);
            } else {
                this.handlePartialEntry(entry);
            }
        }
        catch (ParseException xppe1) {
            try {
                if (this.hasMoreData()) {
                    this.skipToNextEntry();
                }
            }
            catch (XmlPullParserException xppe2) {
                this.isInBadState = true;
            }
            throw new ParseException("Could not parse <entry>, " + entry, xppe1);
        }
        catch (XmlPullParserException xppe1) {
            try {
                if (this.hasMoreData()) {
                    this.skipToNextEntry();
                }
            }
            catch (XmlPullParserException xppe2) {
                this.isInBadState = true;
            }
            throw new ParseException("Could not parse <entry>, " + entry, xppe1);
        }
        return entry;
    }

    public Entry parseStandaloneEntry() throws ParseException, IOException {
        int eventType;
        this.fields = null;
        Entry entry = this.createEntry();
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse GData entry.", e);
        }
        if (eventType != 0) {
            throw new ParseException("Attempting to initialize parsing beyond the start of the document.");
        }
        try {
            eventType = this.parser.next();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not read next event.", xppe);
        }
        catch (IOException ioe) {
            throw new ParseException("Could not read next event.", ioe);
        }
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (XmlNametable.PARTIAL.equals(name)) {
                        try {
                            this.handlePartialEntry(entry);
                            return entry;
                        }
                        catch (XmlPullParserException xppe) {
                            throw new ParseException("Unable to parse <partial> entry.", xppe);
                        }
                        catch (IOException ioe) {
                            throw new ParseException("Unable to parse <partial> entry.", ioe);
                        }
                    }
                    if (!XmlNametable.ENTRY.equals(name)) break;
                    try {
                        this.handleEntry(entry);
                        return entry;
                    }
                    catch (XmlPullParserException xppe) {
                        throw new ParseException("Unable to parse <entry>.", xppe);
                    }
                    catch (IOException ioe) {
                        throw new ParseException("Unable to parse <entry>.", ioe);
                    }
                }
            }
            try {
                eventType = this.parser.next();
            }
            catch (XmlPullParserException xppe) {
                throw new ParseException("Could not read next event.", xppe);
            }
        }
        throw new ParseException("No <entry> found in document.");
    }

    protected void skipToNextEntry() throws IOException, XmlPullParserException {
        if (!this.hasMoreData()) {
            throw new IllegalStateException("you shouldn't call this if hasMoreData() is false");
        }
        int eventType = this.parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    if (!XmlNametable.ENTRY.equals(this.parser.getName())) break;
                    return;
                }
            }
            eventType = this.parser.next();
        }
    }

    protected void skipSubTree() throws XmlPullParserException, IOException {
        int level = 1;
        while (level > 0) {
            int eventType = this.parser.next();
            switch (eventType) {
                case 2: {
                    ++level;
                    break;
                }
                case 3: {
                    --level;
                    break;
                }
            }
        }
    }

    protected void handlePartialEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
        if (!XmlNametable.PARTIAL.equals(this.parser.getName())) {
            throw new IllegalStateException("Expected <partial>: Actual element: <" + this.parser.getName() + ">");
        }
        this.fields = this.parser.getAttributeValue(null, XmlNametable.FIELDS);
        this.parser.next();
        int eventType = this.parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (!XmlNametable.ENTRY.equals(name)) break;
                    this.handleEntry(entry);
                    return;
                }
            }
            eventType = this.parser.next();
        }
    }

    protected void handleEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
        if (!XmlNametable.ENTRY.equals(this.parser.getName())) {
            throw new IllegalStateException("Expected <entry>: Actual element: <" + this.parser.getName() + ">");
        }
        entry.setETag(this.parser.getAttributeValue(NAMESPACE_GD_URI, XmlNametable.ETAG));
        entry.setFields(this.fields);
        this.parser.next();
        int eventType = this.parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (XmlNametable.ENTRY.equals(name)) {
                        return;
                    }
                    if (this.handleDefaultEntryElements(entry)) break;
                    if (NAMESPACE_BATCH_URI.equals(this.parser.getNamespace())) {
                        this.handleBatchInfo(entry);
                        break;
                    }
                    if (XmlNametable.ID.equals(name)) {
                        entry.setId(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.TITLE.equals(name)) {
                        entry.setTitle(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.LINK.equals(name)) {
                        String rel = this.parser.getAttributeValue(null, XmlNametable.REL);
                        String type = this.parser.getAttributeValue(null, XmlNametable.TYPE);
                        String href = this.parser.getAttributeValue(null, XmlNametable.HREF);
                        if (XmlNametable.EDIT_REL.equals(rel)) {
                            entry.setEditUri(href);
                            break;
                        }
                        if (XmlNametable.ALTERNATE_REL.equals(rel) && XmlNametable.TEXTHTML.equals(type)) {
                            entry.setHtmlUri(href);
                            break;
                        }
                        this.handleExtraLinkInEntry(rel, type, href, entry);
                        break;
                    }
                    if (XmlNametable.SUMMARY.equals(name)) {
                        entry.setSummary(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.CONTENT.equals(name)) {
                        entry.setContentType(this.parser.getAttributeValue(null, XmlNametable.TYPE));
                        entry.setContentSource(this.parser.getAttributeValue(null, XmlNametable.SRC));
                        entry.setContent(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.AUTHOR.equals(name)) {
                        this.handleAuthor(entry);
                        break;
                    }
                    if (XmlNametable.CATEGORY.equals(name)) {
                        String categoryScheme;
                        String category = this.parser.getAttributeValue(null, XmlNametable.TERM);
                        if (category != null && category.length() > 0) {
                            entry.setCategory(category);
                        }
                        if ((categoryScheme = this.parser.getAttributeValue(null, XmlNametable.SCHEME)) == null || category.length() <= 0) break;
                        entry.setCategoryScheme(categoryScheme);
                        break;
                    }
                    if (XmlNametable.PUBLISHED.equals(name)) {
                        entry.setPublicationDate(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.UPDATED.equals(name)) {
                        entry.setUpdateDate(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if (XmlNametable.DELETED.equals(name)) {
                        entry.setDeleted(true);
                        break;
                    }
                    this.handleExtraElementInEntry(entry);
                    break;
                }
            }
            eventType = this.parser.next();
        }
        entry.validate();
    }

    private void handleAuthor(Entry entry) throws XmlPullParserException, IOException {
        int eventType = this.parser.getEventType();
        String name = this.parser.getName();
        if (eventType != 2 || !XmlNametable.AUTHOR.equals(this.parser.getName())) {
            throw new IllegalStateException("Expected <author>: Actual element: <" + this.parser.getName() + ">");
        }
        eventType = this.parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    name = this.parser.getName();
                    if (XmlNametable.NAME.equals(name)) {
                        String authorName = XmlUtils.extractChildText(this.parser);
                        entry.setAuthor(authorName);
                        break;
                    }
                    if (!XmlNametable.EMAIL.equals(name)) break;
                    String email = XmlUtils.extractChildText(this.parser);
                    entry.setEmail(email);
                    break;
                }
                case 3: {
                    name = this.parser.getName();
                    if (!XmlNametable.AUTHOR.equals(name)) break;
                    return;
                }
            }
            eventType = this.parser.next();
        }
    }

    private void handleBatchInfo(Entry entry) throws IOException, XmlPullParserException {
        String name = this.parser.getName();
        if (XmlNametable.STATUS.equals(name)) {
            BatchStatus status = new BatchStatus();
            BatchUtils.setBatchStatus(entry, status);
            status.setStatusCode(XmlGDataParser.getIntAttribute(this.parser, XmlNametable.CODE));
            status.setReason(XmlGDataParser.getAttribute(this.parser, XmlNametable.REASON));
            status.setContentType(XmlGDataParser.getAttribute(this.parser, XmlNametable.CONTENT_TYPE));
            this.skipSubTree();
        } else if (XmlNametable.ID.equals(name)) {
            BatchUtils.setBatchId(entry, XmlUtils.extractChildText(this.parser));
        } else if (XmlNametable.OPERATION.equals(name)) {
            BatchUtils.setBatchOperation(entry, XmlGDataParser.getAttribute(this.parser, XmlNametable.TYPE));
        } else if ("interrupted".equals(name)) {
            BatchInterrupted interrupted = new BatchInterrupted();
            BatchUtils.setBatchInterrupted(entry, interrupted);
            interrupted.setReason(XmlGDataParser.getAttribute(this.parser, XmlNametable.REASON));
            interrupted.setErrorCount(XmlGDataParser.getIntAttribute(this.parser, XmlNametable.ERROR));
            interrupted.setSuccessCount(XmlGDataParser.getIntAttribute(this.parser, XmlNametable.SUCCESS));
            interrupted.setTotalCount(XmlGDataParser.getIntAttribute(this.parser, XmlNametable.PARSED));
            this.skipSubTree();
        } else {
            throw new XmlPullParserException("Unexpected batch element " + name);
        }
    }

    private static String getAttribute(XmlPullParser parser, String name) {
        return parser.getAttributeValue(null, name);
    }

    private static int getIntAttribute(XmlPullParser parser, String name) {
        return Integer.parseInt(XmlGDataParser.getAttribute(parser, name));
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
    }

    protected boolean handleDefaultEntryElements(Entry entry) throws XmlPullParserException, IOException {
        return false;
    }

    protected void handleExtraLinkInEntry(String rel, String type, String href, Entry entry) throws XmlPullParserException, IOException {
    }
}

