/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.data.batch;

import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.batch.BatchInfo;
import com.google.wireless.gdata2.data.batch.BatchInterrupted;
import com.google.wireless.gdata2.data.batch.BatchStatus;

public class BatchUtils {
    public static final String OPERATION_INSERT = "insert";
    public static final String OPERATION_UPDATE = "update";
    public static final String OPERATION_QUERY = "query";
    public static final String OPERATION_DELETE = "delete";

    private BatchUtils() {
    }

    public static String getBatchId(Entry entry) {
        BatchInfo info = entry.getBatchInfo();
        return info == null ? null : info.id;
    }

    public static void setBatchId(Entry entry, String id) {
        BatchUtils.getOrCreateBatchInfo((Entry)entry).id = id;
    }

    public static String getBatchOperation(Entry entry) {
        BatchInfo info = entry.getBatchInfo();
        return info == null ? null : info.operation;
    }

    public static void setBatchOperation(Entry entry, String operation) {
        BatchUtils.getOrCreateBatchInfo((Entry)entry).operation = operation;
    }

    public static BatchStatus getBatchStatus(Entry entry) {
        BatchInfo info = entry.getBatchInfo();
        return info == null ? null : info.status;
    }

    public static void setBatchStatus(Entry entry, BatchStatus status) {
        BatchUtils.getOrCreateBatchInfo((Entry)entry).status = status;
    }

    public static BatchInterrupted getBatchInterrupted(Entry entry) {
        BatchInfo info = entry.getBatchInfo();
        return info == null ? null : info.interrupted;
    }

    public static void setBatchInterrupted(Entry entry, BatchInterrupted interrupted) {
        BatchUtils.getOrCreateBatchInfo((Entry)entry).interrupted = interrupted;
    }

    private static BatchInfo getOrCreateBatchInfo(Entry entry) {
        BatchInfo info = entry.getBatchInfo();
        if (info == null) {
            info = new BatchInfo();
            entry.setBatchInfo(info);
        }
        return info;
    }
}

