/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.calendar.client;

import com.google.wireless.gdata2.calendar.data.CalendarEntry;
import com.google.wireless.gdata2.client.GDataClient;
import com.google.wireless.gdata2.client.GDataParserFactory;
import com.google.wireless.gdata2.client.GDataServiceClient;
import com.google.wireless.gdata2.client.HttpException;
import com.google.wireless.gdata2.client.QueryParams;
import com.google.wireless.gdata2.parser.GDataParser;
import com.google.wireless.gdata2.parser.ParseException;
import java.io.IOException;
import java.io.InputStream;

public class CalendarClient
extends GDataServiceClient {
    public static final String SERVICE = "cl";
    public static final String PROJECTION_PRIVATE_FULL = "/private/full";
    public static final String PROJECTION_PRIVATE_SELF_ATTENDANCE = "/private/full-selfattendance";
    private static final String CALENDAR_BASE_FEED_URL = "http://www.google.com/calendar/feeds/";

    public CalendarClient(GDataClient client, GDataParserFactory factory) {
        super(client, factory);
    }

    public String getServiceName() {
        return SERVICE;
    }

    public String getProtocolVersion() {
        return DEFAULT_GDATA_VERSION;
    }

    public String getDefaultCalendarUrl(String username, String projection, QueryParams params) {
        String feedUrl = CALENDAR_BASE_FEED_URL + this.getGDataClient().encodeUri(username);
        feedUrl = feedUrl + projection;
        if (params == null) {
            return feedUrl;
        }
        return params.generateQueryUrl(feedUrl);
    }

    public String getUserCalendarsUrl(String username) {
        return CALENDAR_BASE_FEED_URL + this.getGDataClient().encodeUri(username);
    }

    public GDataParser getParserForUserCalendars(String feedUrl, String authToken) throws ParseException, IOException, HttpException {
        GDataClient gDataClient = this.getGDataClient();
        InputStream is = gDataClient.getFeedAsStream(feedUrl, authToken, null, this.getProtocolVersion());
        return this.getGDataParserFactory().createParser(CalendarEntry.class, is);
    }
}

