/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.contacts.parser.xml;

import com.google.wireless.gdata.contacts.data.ContactEntry;
import com.google.wireless.gdata.contacts.data.ContactsElement;
import com.google.wireless.gdata.contacts.data.ContactsFeed;
import com.google.wireless.gdata.contacts.data.EmailAddress;
import com.google.wireless.gdata.contacts.data.GroupMembershipInfo;
import com.google.wireless.gdata.contacts.data.ImAddress;
import com.google.wireless.gdata.contacts.data.Organization;
import com.google.wireless.gdata.contacts.data.PhoneNumber;
import com.google.wireless.gdata.contacts.data.PostalAddress;
import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.ExtendedProperty;
import com.google.wireless.gdata.data.Feed;
import com.google.wireless.gdata.data.XmlUtils;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlGDataParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlContactsGDataParser
extends XmlGDataParser {
    public static final String NAMESPACE_CONTACTS = "gContact";
    public static final String NAMESPACE_CONTACTS_URI = "http://schemas.google.com/contact/2008";
    public static final String LINK_REL_PHOTO = "http://schemas.google.com/contacts/2008/rel#photo";
    public static final String LINK_REL_EDIT_PHOTO = "http://schemas.google.com/contacts/2008/rel#edit-photo";
    private static final String GD_NAMESPACE = "http://schemas.google.com/g/2005#";
    public static final String TYPESTRING_MOBILE = "http://schemas.google.com/g/2005#mobile";
    public static final String TYPESTRING_HOME = "http://schemas.google.com/g/2005#home";
    public static final String TYPESTRING_WORK = "http://schemas.google.com/g/2005#work";
    public static final String TYPESTRING_HOME_FAX = "http://schemas.google.com/g/2005#home_fax";
    public static final String TYPESTRING_WORK_FAX = "http://schemas.google.com/g/2005#work_fax";
    public static final String TYPESTRING_PAGER = "http://schemas.google.com/g/2005#pager";
    public static final String TYPESTRING_OTHER = "http://schemas.google.com/g/2005#other";
    public static final String IM_PROTOCOL_AIM = "http://schemas.google.com/g/2005#AIM";
    public static final String IM_PROTOCOL_MSN = "http://schemas.google.com/g/2005#MSN";
    public static final String IM_PROTOCOL_YAHOO = "http://schemas.google.com/g/2005#YAHOO";
    public static final String IM_PROTOCOL_SKYPE = "http://schemas.google.com/g/2005#SKYPE";
    public static final String IM_PROTOCOL_QQ = "http://schemas.google.com/g/2005#QQ";
    public static final String IM_PROTOCOL_GOOGLE_TALK = "http://schemas.google.com/g/2005#GOOGLE_TALK";
    public static final String IM_PROTOCOL_ICQ = "http://schemas.google.com/g/2005#ICQ";
    public static final String IM_PROTOCOL_JABBER = "http://schemas.google.com/g/2005#JABBER";
    private static final Hashtable REL_TO_TYPE_EMAIL;
    private static final Hashtable REL_TO_TYPE_PHONE;
    private static final Hashtable REL_TO_TYPE_POSTAL;
    private static final Hashtable REL_TO_TYPE_IM;
    private static final Hashtable REL_TO_TYPE_ORGANIZATION;
    private static final Hashtable IM_PROTOCOL_STRING_TO_TYPE_MAP;
    public static final Hashtable TYPE_TO_REL_EMAIL;
    public static final Hashtable TYPE_TO_REL_PHONE;
    public static final Hashtable TYPE_TO_REL_POSTAL;
    public static final Hashtable TYPE_TO_REL_IM;
    public static final Hashtable TYPE_TO_REL_ORGANIZATION;
    public static final Hashtable IM_PROTOCOL_TYPE_TO_STRING_MAP;

    private static Hashtable swapMap(Hashtable originalMap) {
        Hashtable newMap = new Hashtable();
        Enumeration enumeration = originalMap.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = originalMap.get(key);
            if (newMap.containsKey(value)) {
                throw new IllegalArgumentException("value " + value + " was already encountered");
            }
            newMap.put(value, key);
        }
        return newMap;
    }

    public XmlContactsGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        super(is, parser);
    }

    protected Feed createFeed() {
        return new ContactsFeed();
    }

    protected Entry createEntry() {
        return new ContactEntry();
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getParser();
        if (!(entry instanceof ContactEntry)) {
            throw new IllegalArgumentException("Expected ContactEntry!");
        }
        ContactEntry contactEntry = (ContactEntry)entry;
        String name = parser.getName();
        if ("email".equals(name)) {
            EmailAddress emailAddress = new EmailAddress();
            XmlContactsGDataParser.parseContactsElement(emailAddress, parser, REL_TO_TYPE_EMAIL);
            if (emailAddress.getType() == 4) {
                emailAddress.setType((byte)3);
                emailAddress.setIsPrimary(true);
                emailAddress.setLabel(null);
            }
            emailAddress.setAddress(parser.getAttributeValue(null, "address"));
            contactEntry.addEmailAddress(emailAddress);
        } else if ("deleted".equals(name)) {
            contactEntry.setDeleted(true);
        } else if ("im".equals(name)) {
            ImAddress imAddress = new ImAddress();
            XmlContactsGDataParser.parseContactsElement(imAddress, parser, REL_TO_TYPE_IM);
            imAddress.setAddress(parser.getAttributeValue(null, "address"));
            imAddress.setLabel(parser.getAttributeValue(null, "label"));
            String protocolString = parser.getAttributeValue(null, "protocol");
            if (protocolString == null) {
                imAddress.setProtocolPredefined((byte)10);
                imAddress.setProtocolCustom(null);
            } else {
                Byte predefinedProtocol = (Byte)IM_PROTOCOL_STRING_TO_TYPE_MAP.get(protocolString);
                if (predefinedProtocol == null) {
                    imAddress.setProtocolPredefined((byte)1);
                    imAddress.setProtocolCustom(protocolString);
                } else {
                    imAddress.setProtocolPredefined(predefinedProtocol);
                    imAddress.setProtocolCustom(null);
                }
            }
            contactEntry.addImAddress(imAddress);
        } else if ("postalAddress".equals(name)) {
            PostalAddress postalAddress = new PostalAddress();
            XmlContactsGDataParser.parseContactsElement(postalAddress, parser, REL_TO_TYPE_POSTAL);
            postalAddress.setValue(XmlUtils.extractChildText(parser));
            contactEntry.addPostalAddress(postalAddress);
        } else if ("phoneNumber".equals(name)) {
            PhoneNumber phoneNumber = new PhoneNumber();
            XmlContactsGDataParser.parseContactsElement(phoneNumber, parser, REL_TO_TYPE_PHONE);
            phoneNumber.setPhoneNumber(XmlUtils.extractChildText(parser));
            contactEntry.addPhoneNumber(phoneNumber);
        } else if ("organization".equals(name)) {
            Organization organization = new Organization();
            XmlContactsGDataParser.parseContactsElement(organization, parser, REL_TO_TYPE_ORGANIZATION);
            XmlContactsGDataParser.handleOrganizationSubElement(organization, parser);
            contactEntry.addOrganization(organization);
        } else if ("extendedProperty".equals(name)) {
            ExtendedProperty extendedProperty = new ExtendedProperty();
            this.parseExtendedProperty(extendedProperty);
            contactEntry.addExtendedProperty(extendedProperty);
        } else if ("groupMembershipInfo".equals(name)) {
            GroupMembershipInfo group = new GroupMembershipInfo();
            group.setGroup(parser.getAttributeValue(null, "href"));
            group.setDeleted("true".equals(parser.getAttributeValue(null, "deleted")));
            contactEntry.addGroup(group);
        } else if ("yomiName".equals(name)) {
            String yomiName = XmlUtils.extractChildText(parser);
            contactEntry.setYomiName(yomiName);
        }
    }

    protected void handleExtraLinkInEntry(String rel, String type, String href, Entry entry) throws XmlPullParserException, IOException {
        if (LINK_REL_PHOTO.equals(rel)) {
            ContactEntry contactEntry = (ContactEntry)entry;
            contactEntry.setLinkPhoto(href, type);
        } else if (LINK_REL_EDIT_PHOTO.equals(rel)) {
            ContactEntry contactEntry = (ContactEntry)entry;
            contactEntry.setLinkEditPhoto(href, type);
        }
    }

    private static void parseContactsElement(ContactsElement element, XmlPullParser parser, Hashtable relToTypeMap) throws XmlPullParserException {
        String rel = parser.getAttributeValue(null, "rel");
        String label = parser.getAttributeValue(null, "label");
        if (label == null && rel == null || label != null && rel != null) {
            rel = TYPESTRING_OTHER;
        }
        if (rel != null) {
            Object type = relToTypeMap.get(rel.toLowerCase());
            if (type == null) {
                throw new XmlPullParserException("unknown rel, " + rel);
            }
            element.setType((Byte)type);
        }
        element.setLabel(label);
        element.setIsPrimary("true".equals(parser.getAttributeValue(null, "primary")));
    }

    private static void handleOrganizationSubElement(Organization element, XmlPullParser parser) throws XmlPullParserException, IOException {
        String tag;
        int depth = parser.getDepth();
        while ((tag = XmlUtils.nextDirectChildTag(parser, depth)) != null) {
            if ("orgName".equals(tag)) {
                element.setName(XmlUtils.extractChildText(parser));
                continue;
            }
            if (!"orgTitle".equals(tag)) continue;
            element.setTitle(XmlUtils.extractChildText(parser));
        }
    }

    private void parseExtendedProperty(ExtendedProperty extendedProperty) throws IOException, XmlPullParserException {
        XmlPullParser parser = this.getParser();
        extendedProperty.setName(parser.getAttributeValue(null, "name"));
        extendedProperty.setValue(parser.getAttributeValue(null, "value"));
        extendedProperty.setXmlBlob(XmlUtils.extractFirstChildTextIgnoreRest(parser));
    }

    static {
        Hashtable<String, Byte> map = new Hashtable<String, Byte>();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        map.put("http://schemas.google.com/g/2005#primary", (byte)4);
        REL_TO_TYPE_EMAIL = map;
        TYPE_TO_REL_EMAIL = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(2));
        map.put(TYPESTRING_MOBILE, new Byte(1));
        map.put(TYPESTRING_PAGER, new Byte(6));
        map.put(TYPESTRING_WORK, new Byte(3));
        map.put(TYPESTRING_HOME_FAX, new Byte(5));
        map.put(TYPESTRING_WORK_FAX, new Byte(4));
        map.put(TYPESTRING_OTHER, new Byte(7));
        REL_TO_TYPE_PHONE = map;
        TYPE_TO_REL_PHONE = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        REL_TO_TYPE_POSTAL = map;
        TYPE_TO_REL_POSTAL = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        REL_TO_TYPE_IM = map;
        TYPE_TO_REL_IM = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_WORK, new Byte(1));
        map.put(TYPESTRING_OTHER, new Byte(2));
        REL_TO_TYPE_ORGANIZATION = map;
        TYPE_TO_REL_ORGANIZATION = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(IM_PROTOCOL_AIM, new Byte(2));
        map.put(IM_PROTOCOL_MSN, new Byte(3));
        map.put(IM_PROTOCOL_YAHOO, new Byte(4));
        map.put(IM_PROTOCOL_SKYPE, new Byte(5));
        map.put(IM_PROTOCOL_QQ, new Byte(6));
        map.put(IM_PROTOCOL_GOOGLE_TALK, new Byte(7));
        map.put(IM_PROTOCOL_ICQ, new Byte(8));
        map.put(IM_PROTOCOL_JABBER, new Byte(9));
        IM_PROTOCOL_STRING_TO_TYPE_MAP = map;
        IM_PROTOCOL_TYPE_TO_STRING_MAP = XmlContactsGDataParser.swapMap(map);
    }
}

