/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.client;

import com.google.wireless.gdata.client.GDataClient;
import com.google.wireless.gdata.client.GDataParserFactory;
import com.google.wireless.gdata.client.HttpException;
import com.google.wireless.gdata.client.QueryParams;
import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.MediaEntry;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.parser.GDataParser;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.serializer.GDataSerializer;
import java.io.IOException;
import java.io.InputStream;

public abstract class GDataServiceClient {
    private final GDataClient gDataClient;
    private final GDataParserFactory gDataParserFactory;

    public GDataServiceClient(GDataClient gDataClient, GDataParserFactory gDataParserFactory) {
        this.gDataClient = gDataClient;
        this.gDataParserFactory = gDataParserFactory;
    }

    protected GDataClient getGDataClient() {
        return this.gDataClient;
    }

    protected GDataParserFactory getGDataParserFactory() {
        return this.gDataParserFactory;
    }

    public abstract String getServiceName();

    public QueryParams createQueryParams() {
        return this.gDataClient.createQueryParams();
    }

    public GDataParser getParserForFeed(Class feedEntryClass, String feedUrl, String authToken) throws ParseException, IOException, HttpException {
        InputStream is = this.gDataClient.getFeedAsStream(feedUrl, authToken);
        return this.gDataParserFactory.createParser(feedEntryClass, is);
    }

    public InputStream getMediaEntryAsStream(String mediaEntryUrl, String authToken) throws IOException, HttpException {
        return this.gDataClient.getMediaEntryAsStream(mediaEntryUrl, authToken);
    }

    public Entry createEntry(String feedUrl, String authToken, Entry entry) throws ParseException, IOException, HttpException {
        GDataSerializer serializer = this.gDataParserFactory.createSerializer(entry);
        InputStream is = this.gDataClient.createEntry(feedUrl, authToken, serializer);
        return this.parseEntry(entry.getClass(), is);
    }

    public Entry getEntry(Class entryClass, String id, String authToken) throws ParseException, IOException, HttpException {
        InputStream is = this.getGDataClient().getFeedAsStream(id, authToken);
        return this.parseEntry(entryClass, is);
    }

    public Entry updateEntry(Entry entry, String authToken) throws ParseException, IOException, HttpException {
        String editUri = entry.getEditUri();
        if (StringUtils.isEmpty(editUri)) {
            throw new ParseException("No edit URI -- cannot update.");
        }
        GDataSerializer serializer = this.gDataParserFactory.createSerializer(entry);
        InputStream is = this.gDataClient.updateEntry(editUri, authToken, serializer);
        return this.parseEntry(entry.getClass(), is);
    }

    public MediaEntry updateMediaEntry(String editUri, InputStream inputStream, String contentType, String authToken) throws IOException, HttpException, ParseException {
        if (StringUtils.isEmpty(editUri)) {
            throw new IllegalArgumentException("No edit URI -- cannot update.");
        }
        InputStream is = this.gDataClient.updateMediaEntry(editUri, authToken, inputStream, contentType);
        return (MediaEntry)this.parseEntry(MediaEntry.class, is);
    }

    public void deleteEntry(String editUri, String authToken) throws IOException, HttpException {
        this.gDataClient.deleteEntry(editUri, authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry parseEntry(Class entryClass, InputStream is) throws ParseException, IOException {
        GDataParser parser = null;
        try {
            parser = this.gDataParserFactory.createParser(entryClass, is);
            Entry entry = parser.parseStandaloneEntry();
            return entry;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

