/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.calendar.serializer.xml;

import com.google.wireless.gdata.calendar.data.EventEntry;
import com.google.wireless.gdata.calendar.data.Reminder;
import com.google.wireless.gdata.calendar.data.When;
import com.google.wireless.gdata.calendar.data.Who;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlParserFactory;
import com.google.wireless.gdata.serializer.xml.XmlEntryGDataSerializer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlpull.v1.XmlSerializer;

public class XmlEventEntryGDataSerializer
extends XmlEntryGDataSerializer {
    public static final String NAMESPACE_GCAL = "gCal";
    public static final String NAMESPACE_GCAL_URI = "http://schemas.google.com/gCal/2005";

    public XmlEventEntryGDataSerializer(XmlParserFactory factory, EventEntry entry) {
        super(factory, entry);
    }

    protected EventEntry getEventEntry() {
        return (EventEntry)this.getEntry();
    }

    protected void declareExtraEntryNamespaces(XmlSerializer serializer) throws IOException {
        serializer.setPrefix(NAMESPACE_GCAL, NAMESPACE_GCAL_URI);
    }

    protected void serializeExtraEntryContents(XmlSerializer serializer, int format) throws IOException, ParseException {
        EventEntry entry = this.getEventEntry();
        XmlEventEntryGDataSerializer.serializeEventStatus(serializer, entry.getStatus());
        XmlEventEntryGDataSerializer.serializeTransparency(serializer, entry.getTransparency());
        XmlEventEntryGDataSerializer.serializeVisibility(serializer, entry.getVisibility());
        if (entry.getSendEventNotifications()) {
            serializer.startTag(NAMESPACE_GCAL_URI, "sendEventNotifications");
            serializer.attribute(null, "value", "true");
            serializer.endTag(NAMESPACE_GCAL_URI, "sendEventNotifications");
        }
        Enumeration attendees = entry.getAttendees().elements();
        while (attendees.hasMoreElements()) {
            Who attendee = (Who)attendees.nextElement();
            XmlEventEntryGDataSerializer.serializeWho(serializer, entry, attendee);
        }
        XmlEventEntryGDataSerializer.serializeRecurrence(serializer, entry.getRecurrence());
        if (entry.getRecurrence() != null) {
            if (entry.getReminders() != null) {
                Enumeration reminders = entry.getReminders().elements();
                while (reminders.hasMoreElements()) {
                    Reminder reminder = (Reminder)reminders.nextElement();
                    XmlEventEntryGDataSerializer.serializeReminder(serializer, reminder);
                }
            }
        } else {
            Enumeration whens = entry.getWhens().elements();
            while (whens.hasMoreElements()) {
                When when = (When)whens.nextElement();
                XmlEventEntryGDataSerializer.serializeWhen(serializer, entry, when);
            }
        }
        XmlEventEntryGDataSerializer.serializeOriginalEvent(serializer, entry.getOriginalEventId(), entry.getOriginalEventStartTime());
        XmlEventEntryGDataSerializer.serializeWhere(serializer, entry.getWhere());
        XmlEventEntryGDataSerializer.serializeCommentsUri(serializer, entry.getCommentsUri());
        Hashtable extendedProperties = entry.getExtendedProperties();
        if (extendedProperties != null) {
            Enumeration propertyNames = extendedProperties.keys();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                String propertyValue = (String)extendedProperties.get(propertyName);
                XmlEventEntryGDataSerializer.serializeExtendedProperty(serializer, propertyName, propertyValue);
            }
        }
        XmlEventEntryGDataSerializer.serializeQuickAdd(serializer, entry.isQuickAdd());
    }

    private static void serializeEventStatus(XmlSerializer serializer, byte status) throws IOException {
        String statusString;
        switch (status) {
            case 0: {
                statusString = "http://schemas.google.com/g/2005#event.tentative";
                break;
            }
            case 2: {
                statusString = "http://schemas.google.com/g/2005#event.canceled";
                break;
            }
            case 1: {
                statusString = "http://schemas.google.com/g/2005#event.confirmed";
                break;
            }
            default: {
                statusString = "http://schemas.google.com/g/2005#event.tentative";
            }
        }
        serializer.startTag("http://schemas.google.com/g/2005", "eventStatus");
        serializer.attribute(null, "value", statusString);
        serializer.endTag("http://schemas.google.com/g/2005", "eventStatus");
    }

    private static void serializeRecurrence(XmlSerializer serializer, String recurrence) throws IOException {
        if (StringUtils.isEmpty(recurrence)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "recurrence");
        serializer.text(recurrence);
        serializer.endTag("http://schemas.google.com/g/2005", "recurrence");
    }

    private static void serializeTransparency(XmlSerializer serializer, byte transparency) throws IOException {
        String transparencyString;
        switch (transparency) {
            case 0: {
                transparencyString = "http://schemas.google.com/g/2005#event.opaque";
                break;
            }
            case 1: {
                transparencyString = "http://schemas.google.com/g/2005#event.transparent";
                break;
            }
            default: {
                transparencyString = "http://schemas.google.com/g/2005#event.transparent";
            }
        }
        serializer.startTag("http://schemas.google.com/g/2005", "transparency");
        serializer.attribute(null, "value", transparencyString);
        serializer.endTag("http://schemas.google.com/g/2005", "transparency");
    }

    private static void serializeVisibility(XmlSerializer serializer, byte visibility) throws IOException {
        String visibilityString;
        switch (visibility) {
            case 0: {
                visibilityString = "http://schemas.google.com/g/2005#event.default";
                break;
            }
            case 1: {
                visibilityString = "http://schemas.google.com/g/2005#event.confidential";
                break;
            }
            case 2: {
                visibilityString = "http://schemas.google.com/g/2005#event.private";
                break;
            }
            case 3: {
                visibilityString = "http://schemas.google.com/g/2005#event.public";
                break;
            }
            default: {
                visibilityString = "http://schemas.google.com/g/2005#event.default";
            }
        }
        serializer.startTag("http://schemas.google.com/g/2005", "visibility");
        serializer.attribute(null, "value", visibilityString);
        serializer.endTag("http://schemas.google.com/g/2005", "visibility");
    }

    private static void serializeSendEventNotifications(XmlSerializer serializer, boolean sendEventNotifications) throws IOException {
        serializer.startTag(NAMESPACE_GCAL_URI, "sendEventNotifications");
        serializer.attribute(null, "value", sendEventNotifications ? "true" : "false");
        serializer.endTag(NAMESPACE_GCAL_URI, "sendEventNotifications");
    }

    private static void serializeGuestsCanModify(XmlSerializer serializer, boolean guestsCanModify) throws IOException {
        serializer.startTag(NAMESPACE_GCAL_URI, "guestsCanModify");
        serializer.attribute(null, "value", guestsCanModify ? "true" : "false");
        serializer.endTag(NAMESPACE_GCAL_URI, "guestsCanModify");
    }

    private static void serializeGuestsCanInviteOthers(XmlSerializer serializer, boolean guestsCanInviteOthers) throws IOException {
        serializer.startTag(NAMESPACE_GCAL_URI, "guestsCanInviteOthers");
        serializer.attribute(null, "value", guestsCanInviteOthers ? "true" : "false");
        serializer.endTag(NAMESPACE_GCAL_URI, "guestsCanInviteOthers");
    }

    private static void serializeGuestsCanSeeGuests(XmlSerializer serializer, boolean guestsCanSeeGuests) throws IOException {
        serializer.startTag(NAMESPACE_GCAL_URI, "guestsCanSeeGuests");
        serializer.attribute(null, "value", guestsCanSeeGuests ? "true" : "false");
        serializer.endTag(NAMESPACE_GCAL_URI, "guestsCanSeeGuests");
    }

    private static void serializeWho(XmlSerializer serializer, EventEntry entry, Who who) throws IOException, ParseException {
        String value;
        serializer.startTag("http://schemas.google.com/g/2005", "who");
        String email = who.getEmail();
        if (!StringUtils.isEmpty(email)) {
            serializer.attribute(null, "email", email);
        }
        if (!StringUtils.isEmpty(value = who.getValue())) {
            serializer.attribute(null, "valueString", value);
        }
        String rel = null;
        switch (who.getRelationship()) {
            case 0: {
                break;
            }
            case 1: {
                rel = "http://schemas.google.com/g/2005#event.attendee";
                break;
            }
            case 2: {
                rel = "http://schemas.google.com/g/2005#event.organizer";
                break;
            }
            case 3: {
                rel = "http://schemas.google.com/g/2005#event.performer";
                break;
            }
            case 4: {
                rel = "http://schemas.google.com/g/2005#event.speaker";
                break;
            }
            default: {
                throw new ParseException("Unexpected rel: " + who.getRelationship());
            }
        }
        if (!StringUtils.isEmpty(rel)) {
            serializer.attribute(null, "rel", rel);
        }
        String status = null;
        switch (who.getStatus()) {
            case 0: {
                break;
            }
            case 1: {
                status = "http://schemas.google.com/g/2005#event.accepted";
                break;
            }
            case 2: {
                status = "http://schemas.google.com/g/2005#event.declined";
                break;
            }
            case 3: {
                status = "http://schemas.google.com/g/2005#event.invited";
                break;
            }
            case 4: {
                status = "http://schemas.google.com/g/2005#event.tentative";
                break;
            }
            default: {
                throw new ParseException("Unexpected status: " + who.getStatus());
            }
        }
        if (!StringUtils.isEmpty(status)) {
            serializer.startTag("http://schemas.google.com/g/2005", "attendeeStatus");
            serializer.attribute(null, "value", status);
            serializer.endTag("http://schemas.google.com/g/2005", "attendeeStatus");
        }
        String type = null;
        switch (who.getType()) {
            case 0: {
                break;
            }
            case 2: {
                type = "http://schemas.google.com/g/2005#event.required";
                break;
            }
            case 1: {
                type = "http://schemas.google.com/g/2005#event.optional";
                break;
            }
            default: {
                throw new ParseException("Unexpected type: " + who.getType());
            }
        }
        if (!StringUtils.isEmpty(type)) {
            serializer.startTag("http://schemas.google.com/g/2005", "attendeeType");
            serializer.attribute(null, "value", type);
            serializer.endTag("http://schemas.google.com/g/2005", "attendeeType");
        }
        serializer.endTag("http://schemas.google.com/g/2005", "who");
    }

    private static void serializeWhen(XmlSerializer serializer, EventEntry entry, When when) throws IOException {
        String startTime = when.getStartTime();
        String endTime = when.getEndTime();
        if (StringUtils.isEmpty(when.getStartTime())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "when");
        serializer.attribute(null, "startTime", startTime);
        if (!StringUtils.isEmpty(endTime)) {
            serializer.attribute(null, "endTime", endTime);
        }
        if (entry.getReminders() != null) {
            Enumeration reminders = entry.getReminders().elements();
            while (reminders.hasMoreElements()) {
                Reminder reminder = (Reminder)reminders.nextElement();
                XmlEventEntryGDataSerializer.serializeReminder(serializer, reminder);
            }
        }
        serializer.endTag("http://schemas.google.com/g/2005", "when");
    }

    private static void serializeReminder(XmlSerializer serializer, Reminder reminder) throws IOException {
        int minutes;
        serializer.startTag("http://schemas.google.com/g/2005", "reminder");
        byte method = reminder.getMethod();
        String methodStr = null;
        switch (method) {
            case 3: {
                methodStr = "alert";
                break;
            }
            case 1: {
                methodStr = "email";
                break;
            }
            case 2: {
                methodStr = "sms";
            }
        }
        if (methodStr != null) {
            serializer.attribute(null, "method", methodStr);
        }
        if ((minutes = reminder.getMinutes()) != -1) {
            serializer.attribute(null, "minutes", Integer.toString(minutes));
        }
        serializer.endTag("http://schemas.google.com/g/2005", "reminder");
    }

    private static void serializeOriginalEvent(XmlSerializer serializer, String originalEventId, String originalEventTime) throws IOException {
        String id;
        if (StringUtils.isEmpty(originalEventId) || StringUtils.isEmpty(originalEventTime)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "originalEvent");
        int index = originalEventId.lastIndexOf("/");
        if (index != -1 && !StringUtils.isEmpty(id = originalEventId.substring(index + 1))) {
            serializer.attribute(null, "id", id);
        }
        serializer.attribute(null, "href", originalEventId);
        serializer.startTag("http://schemas.google.com/g/2005", "when");
        serializer.attribute(null, "startTime", originalEventTime);
        serializer.endTag("http://schemas.google.com/g/2005", "when");
        serializer.endTag("http://schemas.google.com/g/2005", "originalEvent");
    }

    private static void serializeWhere(XmlSerializer serializer, String where) throws IOException {
        if (where == null) {
            where = "";
        }
        serializer.startTag("http://schemas.google.com/g/2005", "where");
        serializer.attribute(null, "valueString", where);
        serializer.endTag("http://schemas.google.com/g/2005", "where");
    }

    private static void serializeCommentsUri(XmlSerializer serializer, String commentsUri) throws IOException {
        if (commentsUri == null) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "feedLink");
        serializer.attribute(null, "href", commentsUri);
        serializer.endTag("http://schemas.google.com/g/2005", "feedLink");
    }

    private static void serializeExtendedProperty(XmlSerializer serializer, String name, String value) throws IOException {
        serializer.startTag("http://schemas.google.com/g/2005", "extendedProperty");
        serializer.attribute(null, "name", name);
        serializer.attribute(null, "value", value);
        serializer.endTag("http://schemas.google.com/g/2005", "extendedProperty");
    }

    private static void serializeQuickAdd(XmlSerializer serializer, boolean quickAdd) throws IOException {
        if (quickAdd) {
            serializer.startTag(NAMESPACE_GCAL, "quickadd");
            serializer.attribute(null, "value", "true");
            serializer.endTag(NAMESPACE_GCAL, "quickadd");
        }
    }
}

