/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gtalkservice;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Presence
implements Parcelable {
    private static final int STATUS_MIN_VERSION_FOR_INVISIBILITY = 2;
    public static final Presence OFFLINE = new Presence();
    private boolean mAvailable;
    private Show mShow;
    private String mStatus;
    private boolean mInvisible;
    private List<String> mDefaultStatusList;
    private List<String> mDndStatusList;
    private int mStatusMax;
    private int mStatusListMax;
    private int mStatusListContentsMax;
    private boolean mAllowInvisibility;
    public static final Parcelable.Creator<Presence> CREATOR = new Parcelable.Creator<Presence>(){

        public Presence createFromParcel(Parcel source) {
            return new Presence(source);
        }

        public Presence[] newArray(int size) {
            return new Presence[size];
        }
    };

    public Presence() {
        this(false, Show.NONE, null);
    }

    public Presence(boolean available, Show show, String status) {
        this.mAvailable = available;
        this.mShow = show;
        this.mStatus = status;
        this.mInvisible = false;
        this.mDefaultStatusList = new ArrayList<String>();
        this.mDndStatusList = new ArrayList<String>();
    }

    public Presence(Parcel source) {
        this.setStatusMax(source.readInt());
        this.setStatusListMax(source.readInt());
        this.setStatusListContentsMax(source.readInt());
        this.setAllowInvisibility(source.readInt() != 0);
        this.setAvailable(source.readInt() != 0);
        this.setShow(Enum.valueOf(Show.class, source.readString()));
        this.mStatus = source.readString();
        this.setInvisible(source.readInt() != 0);
        this.mDefaultStatusList = new ArrayList<String>();
        source.readStringList(this.mDefaultStatusList);
        this.mDndStatusList = new ArrayList<String>();
        source.readStringList(this.mDndStatusList);
    }

    public Presence(Presence presence) {
        this.mStatusMax = presence.mStatusMax;
        this.mStatusListMax = presence.mStatusListMax;
        this.mStatusListContentsMax = presence.mStatusListContentsMax;
        this.mAllowInvisibility = presence.mAllowInvisibility;
        this.mAvailable = presence.mAvailable;
        this.mShow = presence.mShow;
        this.mStatus = presence.mStatus;
        this.mInvisible = presence.mInvisible;
        this.mDefaultStatusList = presence.mDefaultStatusList;
        this.mDndStatusList = presence.mDndStatusList;
    }

    public int getStatusMax() {
        return this.mStatusMax;
    }

    public void setStatusMax(int max) {
        this.mStatusMax = max;
    }

    public int getStatusListMax() {
        return this.mStatusListMax;
    }

    public void setStatusListMax(int max) {
        this.mStatusListMax = max;
    }

    public int getStatusListContentsMax() {
        return this.mStatusListContentsMax;
    }

    public void setStatusListContentsMax(int max) {
        this.mStatusListContentsMax = max;
    }

    public boolean allowInvisibility() {
        return this.mAllowInvisibility;
    }

    public void setAllowInvisibility(boolean allowInvisibility) {
        this.mAllowInvisibility = allowInvisibility;
    }

    public boolean isAvailable() {
        return this.mAvailable;
    }

    public void setAvailable(boolean available) {
        this.mAvailable = available;
    }

    public boolean isInvisible() {
        return this.mInvisible;
    }

    public boolean setInvisible(boolean invisible) {
        this.mInvisible = invisible;
        return !invisible || this.allowInvisibility();
    }

    public Show getShow() {
        return this.mShow;
    }

    public void setShow(Show show) {
        this.mShow = show;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(String status) {
        this.setStatus(status, false);
    }

    private void setStatus(String status, boolean updateLists) {
        this.mStatus = status;
        if (updateLists) {
            switch (this.mShow) {
                case DND: {
                    this.addToList(this.mDndStatusList, status);
                    break;
                }
                case AVAILABLE: {
                    this.addToList(this.mDefaultStatusList, status);
                }
            }
        }
    }

    public void setStatus(Show show, String status) {
        this.setShow(show);
        this.setStatus(status, true);
    }

    private List<String> checkListContentsLength(List<String> list) {
        int maxListContentsLength = this.getStatusListContentsMax();
        int listLength = list.size();
        if (listLength > maxListContentsLength) {
            for (int i = listLength - 1; i >= maxListContentsLength; --i) {
                list.remove(i);
            }
        }
        return list;
    }

    private boolean addToList(List<String> list, String status) {
        if (TextUtils.isEmpty((CharSequence)status)) {
            return false;
        }
        for (String s : list) {
            if (!s.trim().equals(status.trim())) continue;
            return false;
        }
        int statusMax = this.getStatusMax();
        if (status.length() > statusMax) {
            status = status.substring(0, statusMax);
        }
        list.add(0, status);
        this.checkListContentsLength(list);
        return true;
    }

    public List<String> getDefaultStatusList() {
        return new ArrayList<String>(this.mDefaultStatusList);
    }

    public List<String> getDndStatusList() {
        return new ArrayList<String>(this.mDndStatusList);
    }

    public void clearStatusLists() {
        this.mDefaultStatusList.clear();
        this.mDndStatusList.clear();
        this.mStatus = "";
    }

    public boolean equals(Presence other) {
        if (other == null) {
            return false;
        }
        if (this.mAvailable != other.mAvailable) {
            return false;
        }
        if (this.mShow != other.mShow) {
            return false;
        }
        if (this.mStatus != null ? !this.mStatus.equals(other.mStatus) : other.mStatus != null) {
            return false;
        }
        if (this.mInvisible != other.mInvisible) {
            return false;
        }
        if (this.mStatusMax != other.mStatusMax) {
            return false;
        }
        if (this.mStatusListMax != other.mStatusListMax) {
            return false;
        }
        if (this.mStatusListContentsMax != other.mStatusListContentsMax) {
            return false;
        }
        if (this.mAllowInvisibility != other.mAllowInvisibility) {
            return false;
        }
        if (!this.listEqual(this.mDefaultStatusList, other.mDefaultStatusList)) {
            return false;
        }
        return this.listEqual(this.mDndStatusList, other.mDndStatusList);
    }

    private boolean listEqual(List<String> list1, List<String> list2) {
        int count2;
        int count1 = list1.size();
        if (count1 != (count2 = list2.size())) {
            return false;
        }
        for (int i = 0; i < count1; ++i) {
            String s2;
            String s1 = list1.get(i);
            if (s1.equals(s2 = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.getStatusMax());
        dest.writeInt(this.getStatusListMax());
        dest.writeInt(this.getStatusListContentsMax());
        dest.writeInt(this.allowInvisibility() ? 1 : 0);
        dest.writeInt(this.mAvailable ? 1 : 0);
        dest.writeString(this.mShow.toString());
        dest.writeString(this.mStatus);
        dest.writeInt(this.mInvisible ? 1 : 0);
        dest.writeStringList(this.mDefaultStatusList);
        dest.writeStringList(this.mDndStatusList);
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        if (!this.isAvailable()) {
            return "UNAVAILABLE";
        }
        if (this.isInvisible()) {
            return "INVISIBLE";
        }
        String retVal = this.mShow == Show.NONE ? "AVAILABLE(x)" : this.mShow.toString();
        return retVal;
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ available=");
        sb.append(this.mAvailable);
        sb.append(", show=");
        sb.append((Object)this.mShow);
        sb.append(", ");
        sb.append(this.mStatus == null ? "" : this.mStatus);
        sb.append(", invisible=" + this.mInvisible);
        sb.append(", allowInvisible=");
        sb.append(this.mAllowInvisibility);
        sb.append(", default={");
        int i = 0;
        if (this.mDefaultStatusList != null) {
            for (String s : this.mDefaultStatusList) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
        }
        sb.append("}, dnd={");
        if (this.mDndStatusList != null) {
            i = 0;
            for (String s : this.mDndStatusList) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Show {
        NONE,
        AWAY,
        EXTENDED_AWAY,
        DND,
        AVAILABLE;

    }
}

