/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.gdata;

import android.text.TextUtils;
import android.util.Log;
import com.google.wireless.gdata.client.QueryParams;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class QueryParamsImpl
extends QueryParams {
    private final Map<String, String> mParams = new HashMap<String, String>();

    public void clear() {
        this.setEntryId(null);
        this.mParams.clear();
    }

    public String generateQueryUrl(String feedUrl) {
        if (TextUtils.isEmpty((CharSequence)this.getEntryId()) && this.mParams.isEmpty()) {
            return feedUrl;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getEntryId())) {
            if (!this.mParams.isEmpty()) {
                throw new IllegalStateException("Cannot set both an entry ID and other query paramters.");
            }
            return feedUrl + '/' + this.getEntryId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(feedUrl);
        Set<String> params = this.mParams.keySet();
        boolean first = true;
        if (feedUrl.contains("?")) {
            first = false;
        } else {
            sb.append('?');
        }
        for (String param : params) {
            String value = this.mParams.get(param);
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append('&');
            }
            sb.append(param);
            sb.append('=');
            String encodedValue = null;
            try {
                encodedValue = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                Log.w((String)"QueryParamsImpl", (String)"UTF-8 not supported -- should not happen.  Using default encoding.", (Throwable)uee);
                encodedValue = URLEncoder.encode(value);
            }
            sb.append(encodedValue);
        }
        return sb.toString();
    }

    public String getParamValue(String param) {
        if (!this.mParams.containsKey(param)) {
            return null;
        }
        return this.mParams.get(param);
    }

    public void setParamValue(String param, String value) {
        this.mParams.put(param, value);
    }
}

