/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.gdata;

import android.content.ContentResolver;
import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.common.gdata.QueryParamsImpl;
import com.google.android.common.http.GoogleHttpClient;
import com.google.wireless.gdata.client.GDataClient;
import com.google.wireless.gdata.client.HttpException;
import com.google.wireless.gdata.client.QueryParams;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.serializer.GDataSerializer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class AndroidGDataClient
implements GDataClient {
    private static final String TAG = "GDataClient";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    private static final String DEFAULT_USER_AGENT_APP_VERSION = "Android-GData/1.1";
    private static final int MAX_REDIRECTS = 10;
    private final GoogleHttpClient mHttpClient;
    private ContentResolver mResolver;

    public AndroidGDataClient(Context context) {
        this(context, DEFAULT_USER_AGENT_APP_VERSION);
    }

    public AndroidGDataClient(Context context, String appAndVersion) {
        this.mHttpClient = new GoogleHttpClient(context, appAndVersion, true);
        this.mHttpClient.enableCurlLogging(TAG, 2);
        this.mResolver = context.getContentResolver();
    }

    public void close() {
        this.mHttpClient.close();
    }

    public String encodeUri(String uri) {
        String encodedUri;
        try {
            encodedUri = URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e((String)"JakartaGDataClient", (String)"UTF-8 not supported -- should not happen.  Using default encoding.", (Throwable)uee);
            encodedUri = URLEncoder.encode(uri);
        }
        return encodedUri;
    }

    public QueryParams createQueryParams() {
        return new QueryParamsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createAndExecuteMethod(HttpRequestCreator creator, String uriString, String authToken) throws HttpException, IOException {
        URI uri;
        HttpResponse response = null;
        int status = 500;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException use) {
            Log.w((String)TAG, (String)("Unable to parse " + uriString + " as URI."), (Throwable)use);
            throw new IOException("Unable to parse " + uriString + " as URI: " + use.getMessage());
        }
        for (int redirectsLeft = 10; redirectsLeft > 0; --redirectsLeft) {
            HttpUriRequest request = creator.createRequest(uri);
            AndroidHttpClient.modifyRequestToAcceptGzipResponse((HttpRequest)request);
            if (!TextUtils.isEmpty((CharSequence)authToken)) {
                request.addHeader("Authorization", "GoogleLogin auth=" + authToken);
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Executing " + request.getRequestLine().toString()));
            }
            response = null;
            try {
                response = this.mHttpClient.execute(request);
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Unable to execute HTTP request." + ioe));
                throw ioe;
            }
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                Log.w((String)TAG, (String)"StatusLine is null.");
                throw new NullPointerException("StatusLine is null -- should not happen.");
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)response.getStatusLine().toString());
                for (Header h : response.getAllHeaders()) {
                    Log.d((String)TAG, (String)(h.getName() + ": " + h.getValue()));
                }
            }
            status = statusLine.getStatusCode();
            HttpEntity entity = response.getEntity();
            if (status >= 200 && status < 300 && entity != null) {
                InputStream in = AndroidHttpClient.getUngzippedContent((HttpEntity)entity);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    in = this.logInputStreamContents(in);
                }
                return in;
            }
            if (status != 302) break;
            entity.consumeContent();
            Header location = response.getFirstHeader("Location");
            if (location == null) {
                if (!Log.isLoggable((String)TAG, (int)3)) break;
                Log.d((String)TAG, (String)"Redirect requested but no Location specified.");
                break;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Following redirect to " + location.getValue()));
            }
            try {
                uri = new URI(location.getValue());
                continue;
            }
            catch (URISyntaxException use) {
                if (!Log.isLoggable((String)TAG, (int)3)) break;
                Log.d((String)TAG, (String)("Unable to parse " + location.getValue() + " as URI."), (Throwable)use);
                throw new IOException("Unable to parse " + location.getValue() + " as URI.");
            }
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Received " + status + " status code."));
        }
        String errorMessage = null;
        HttpEntity entity = response.getEntity();
        try {
            if (response != null && entity != null) {
                InputStream in = AndroidHttpClient.getUngzippedContent((HttpEntity)entity);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[8192];
                int bytesRead = -1;
                while ((bytesRead = in.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                errorMessage = new String(baos.toByteArray());
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)errorMessage);
                }
            }
        }
        finally {
            if (entity != null) {
                entity.consumeContent();
            }
        }
        String exceptionMessage = "Received " + status + " status code";
        if (errorMessage != null) {
            exceptionMessage = exceptionMessage + ": " + errorMessage;
        }
        throw new HttpException(exceptionMessage, status, null);
    }

    public InputStream getFeedAsStream(String feedUrl, String authToken) throws HttpException, IOException {
        InputStream in = this.createAndExecuteMethod(new GetRequestCreator(), feedUrl, authToken);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to access feed.");
    }

    private InputStream logInputStreamContents(InputStream in) throws IOException {
        int got;
        if (in == null) {
            return in;
        }
        int bufferSize = 16384;
        BufferedInputStream bin = new BufferedInputStream(in, 16384);
        bin.mark(16384);
        int wanted = 16384;
        int totalReceived = 0;
        byte[] buf = new byte[wanted];
        while (wanted > 0 && (got = bin.read(buf, totalReceived, wanted)) > 0) {
            wanted -= got;
            totalReceived += got;
        }
        Log.d((String)TAG, (String)new String(buf, 0, totalReceived, "UTF-8"));
        bin.reset();
        return bin;
    }

    public InputStream getMediaEntryAsStream(String mediaEntryUrl, String authToken) throws HttpException, IOException {
        InputStream in = this.createAndExecuteMethod(new GetRequestCreator(), mediaEntryUrl, authToken);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to access media entry.");
    }

    public InputStream createEntry(String feedUrl, String authToken, GDataSerializer entry) throws HttpException, IOException {
        HttpEntity entity = this.createEntityForEntry(entry, 1);
        InputStream in = this.createAndExecuteMethod(new PostRequestCreator(null, entity), feedUrl, authToken);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to create entry.");
    }

    public InputStream updateEntry(String editUri, String authToken, GDataSerializer entry) throws HttpException, IOException {
        HttpEntity entity = this.createEntityForEntry(entry, 2);
        InputStream in = this.createAndExecuteMethod(new PostRequestCreator("PUT", entity), editUri, authToken);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to update entry.");
    }

    public void deleteEntry(String editUri, String authToken) throws HttpException, IOException {
        if (StringUtils.isEmpty(editUri)) {
            throw new IllegalArgumentException("you must specify an non-empty edit url");
        }
        InputStream in = this.createAndExecuteMethod(new PostRequestCreator("DELETE", null), editUri, authToken);
        if (in == null) {
            throw new IOException("Unable to delete entry.");
        }
        try {
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public InputStream updateMediaEntry(String editUri, String authToken, InputStream mediaEntryInputStream, String contentType) throws HttpException, IOException {
        InputStream in = this.createAndExecuteMethod(new MediaPutRequestCreator(mediaEntryInputStream, contentType), editUri, authToken);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to write media entry.");
    }

    private HttpEntity createEntityForEntry(GDataSerializer entry, int format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            entry.serialize(baos, format);
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"Unable to serialize entry.", (Throwable)ioe);
            throw ioe;
        }
        catch (ParseException pe) {
            Log.e((String)TAG, (String)"Unable to serialize entry.", (Throwable)pe);
            throw new IOException("Unable to serialize entry: " + pe.getMessage());
        }
        byte[] entryBytes = baos.toByteArray();
        if (entryBytes != null && Log.isLoggable((String)TAG, (int)3)) {
            try {
                Log.d((String)TAG, (String)("Serialized entry: " + new String(entryBytes, "UTF-8")));
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException("UTF-8 should be supported!", uee);
            }
        }
        AbstractHttpEntity entity = AndroidHttpClient.getCompressedEntity((byte[])entryBytes, (ContentResolver)this.mResolver);
        entity.setContentType(entry.getContentType());
        return entity;
    }

    private static class MediaPutRequestCreator
    implements HttpRequestCreator {
        private final InputStream mMediaInputStream;
        private final String mContentType;

        public MediaPutRequestCreator(InputStream mediaInputStream, String contentType) {
            this.mMediaInputStream = mediaInputStream;
            this.mContentType = contentType;
        }

        public HttpUriRequest createRequest(URI uri) {
            HttpPost post = new HttpPost(uri);
            post.addHeader(AndroidGDataClient.X_HTTP_METHOD_OVERRIDE, "PUT");
            InputStreamEntity entity = new InputStreamEntity(this.mMediaInputStream, -1L);
            entity.setContentType(this.mContentType);
            post.setEntity((HttpEntity)entity);
            return post;
        }
    }

    private static class PostRequestCreator
    implements HttpRequestCreator {
        private final String mMethodOverride;
        private final HttpEntity mEntity;

        public PostRequestCreator(String methodOverride, HttpEntity entity) {
            this.mMethodOverride = methodOverride;
            this.mEntity = entity;
        }

        public HttpUriRequest createRequest(URI uri) {
            HttpPost post = new HttpPost(uri);
            if (this.mMethodOverride != null) {
                post.addHeader(AndroidGDataClient.X_HTTP_METHOD_OVERRIDE, this.mMethodOverride);
            }
            post.setEntity(this.mEntity);
            return post;
        }
    }

    private static class GetRequestCreator
    implements HttpRequestCreator {
        public HttpUriRequest createRequest(URI uri) {
            HttpGet get = new HttpGet(uri);
            return get;
        }
    }

    private static interface HttpRequestCreator {
        public HttpUriRequest createRequest(URI var1);
    }
}

