/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.android.common.OperationScheduler;
import com.google.android.common.http.GoogleHttpClient;
import com.google.android.gsf.Gservices;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class ParentalControl {
    private static final String TAG = "ParentalControl";
    private static final String LITMUS_URL = "http://android.clients.google.com/content/default";
    private static final long DEFAULT_TIMEOUT_MILLIS = 43200000L;
    private static final String PREFS_NAME = "ParentalControl";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_LANDING_URL = "landingUrl";
    private static final String FEATURE_ENABLE_HIPRI = "enableHIPRI";
    private static final int APN_ALREADY_ACTIVE = 0;
    private static final int APN_REQUEST_STARTED = 1;
    private static final int HIPRI_ATTEMPTS = 20;
    private static final int HIPRI_ATTEMPT_MILLIS = 1000;
    public static final String VENDING_APP = "vending";
    public static final String YOUTUBE_APP = "youtube";

    public static boolean isEnabled(Context context, String app) {
        String apps;
        ContentResolver cr;
        if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
            Log.wtf((String)"ParentalControl", (String)"Network request on main thread");
        }
        if (!Gservices.getBoolean(cr = context.getContentResolver(), "parental_control_check_enabled", false)) {
            return false;
        }
        if (app != null && (apps = Gservices.getString(cr, "parental_control_apps_list")) != null && !apps.contains(app)) {
            return false;
        }
        ParentalControl.maybeCheckState(context);
        return context.getSharedPreferences("ParentalControl", 0).getBoolean(KEY_ENABLED, false);
    }

    public static Uri getLandingPage(Context context, String app) {
        if (!ParentalControl.isEnabled(context, app)) {
            return null;
        }
        SharedPreferences prefs = context.getSharedPreferences("ParentalControl", 0);
        String value = prefs.getString(KEY_LANDING_URL, "");
        return value.length() == 0 ? null : Uri.parse((String)value);
    }

    private static boolean isHipriActive(ConnectivityManager cm) {
        return cm.getNetworkInfo(5).isConnected();
    }

    private static boolean waitForHipri(ConnectivityManager cm) {
        boolean alreadyActive = ParentalControl.isHipriActive(cm);
        int result = cm.startUsingNetworkFeature(0, FEATURE_ENABLE_HIPRI);
        if (alreadyActive) {
            return true;
        }
        if (result != 0 && result != 1) {
            Log.e((String)"ParentalControl", (String)("Parental control unchanged: Mobile network error, code " + result));
            return false;
        }
        for (int i = 0; i < 20; ++i) {
            Log.i((String)"ParentalControl", (String)"Waiting 1000ms for mobile network");
            SystemClock.sleep((long)1000L);
            if (!ParentalControl.isHipriActive(cm)) continue;
            return true;
        }
        Log.e((String)"ParentalControl", (String)"Parental control unchanged: Timed out waiting for mobile network");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeCheckState(Context context) {
        ContentResolver cr = context.getContentResolver();
        SharedPreferences prefs = context.getSharedPreferences("ParentalControl", 0);
        OperationScheduler scheduler = new OperationScheduler(prefs);
        OperationScheduler.Options options = new OperationScheduler.Options();
        options.periodicIntervalMillis = Gservices.getLong(cr, "parental_control_timeout_in_ms", 43200000L);
        if (new File("/proc/1").lastModified() > scheduler.getLastSuccessTimeMillis()) {
            scheduler.setTriggerTimeMillis(0L);
        }
        if (scheduler.getNextTimeMillis(options) > System.currentTimeMillis()) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            Log.e((String)"ParentalControl", (String)"Parental control unchanged: No ConnectivityManager");
            return;
        }
        GoogleHttpClient client = new GoogleHttpClient(context, "Android-PC", false);
        try {
            if (!ParentalControl.waitForHipri(cm)) {
                scheduler.onTransientError();
                return;
            }
            Uri uri = Uri.parse((String)LITMUS_URL);
            InetAddress addr = InetAddress.getByName(uri.getHost());
            byte[] octets = addr.getAddress();
            if (!cm.requestRouteToHost(5, (octets[3] & 0xFF) << 24 | (octets[2] & 0xFF) << 16 | (octets[1] & 0xFF) << 8 | octets[0] & 0xFF)) {
                Log.e((String)"ParentalControl", (String)("Parental control unchanged: Error rerouting " + addr));
                scheduler.onTransientError();
                return;
            }
            String hostport = uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : "");
            uri = uri.buildUpon().authority(hostport).build();
            Log.i((String)"ParentalControl", (String)("Attempting litmus URL fetch: " + uri));
            HttpGet request = new HttpGet(uri.toString());
            request.setHeader("Connection", "close");
            HttpResponse response = client.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                String expected = Gservices.getString(cr, "parental_control_expected_response");
                if (expected == null || expected.equals(EntityUtils.toString((HttpEntity)response.getEntity()).trim())) {
                    Log.i((String)"ParentalControl", (String)"Parental control is OFF: Litmus fetch succeeded");
                    scheduler.onSuccess();
                    prefs.edit().putBoolean(KEY_ENABLED, false);
                } else {
                    Log.i((String)"ParentalControl", (String)"Parental control is ON: Litmus content was modified");
                    scheduler.onSuccess();
                    prefs.edit().putBoolean(KEY_ENABLED, true).putString(KEY_LANDING_URL, "").commit();
                }
            } else if (status == 302) {
                String url;
                String whitelist = Gservices.getString(cr, "parental_control_redirect_regex");
                Header redirect = response.getFirstHeader("location");
                String string = url = redirect == null ? null : redirect.getValue();
                if (whitelist != null && url != null && Pattern.matches(whitelist, url)) {
                    Log.i((String)"ParentalControl", (String)("Parental control is ON: Litmus redirects to " + url));
                    scheduler.onSuccess();
                    prefs.edit().putBoolean(KEY_ENABLED, true).putString(KEY_LANDING_URL, url).commit();
                } else {
                    scheduler.onTransientError();
                    Log.i((String)"ParentalControl", (String)("Parental control unchanged: Unknown litmus redirect " + (url == null ? "(none)" : url)));
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"ParentalControl", (String)"Parental control unchanged: Litmus fetch failed", (Throwable)e);
            scheduler.onTransientError();
        }
        finally {
            client.close();
            cm.stopUsingNetworkFeature(0, FEATURE_ENABLE_HIPRI);
        }
    }

    private ParentalControl() {
    }
}

