/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.net.TrafficStats;
import android.os.Bundle;
import android.os.Process;
import android.util.EventLog;

public abstract class LoggingThreadedSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String TAG = "Sync";

    public LoggingThreadedSyncAdapter(Context context, boolean autoInitialize) {
        super(context, autoInitialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider, SyncResult syncResult) {
        int uid = Process.myUid();
        long initialTxBytes = TrafficStats.getUidTxBytes((int)uid);
        long initialRxBytes = TrafficStats.getUidRxBytes((int)uid);
        try {
            this.onPerformLoggedSync(account, extras, authority, provider, syncResult);
        }
        finally {
            this.onLogSyncDetails(TrafficStats.getUidTxBytes((int)uid) - initialTxBytes, TrafficStats.getUidRxBytes((int)uid) - initialRxBytes, syncResult);
        }
    }

    public abstract void onPerformLoggedSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    protected void onLogSyncDetails(long bytesSent, long bytesReceived, SyncResult result) {
        EventLog.writeEvent((int)203001, (Object[])new Object[]{TAG, bytesSent, bytesReceived, ""});
    }
}

