# Credits & Acknowledgements

This project would not be possible without the amazing work of the open-source community.  
Below is a list of dependencies, algorithms, and contributions used in File85Toolkit.

---

## Compression & Algorithms

- **XZ for Java (LZMA/XZ support)**
  - Artifact: `org.tukaani:xz:1.9`
  - Author: Lasse Collin / Tukaani Project
  - Source: https://tukaani.org/xz/java.html
  - License: Public Domain (Unlicense)

- **Base85 Encoding / File85 Algorithm**
  - Custom implementation inspired by existing Base85 work
  - Original concept by [Author/Repo you referenced here]
  - License: As credited in original source

---

## Android Libraries

- **Material Components for Android**
  - Artifact: `com.google.android.material:material:1.12.0`
  - Author: Google / Android Open Source Project
  - Source: https://github.com/material-components/material-components-android
  - License: Apache License 2.0

- **Jetpack Compose & AndroidX**
  - Artifacts:
    - `androidx.compose:compose-bom:2024.09.01`
    - `androidx.activity:activity-compose:1.9.2`
    - `androidx.compose.ui:ui`
    - `androidx.compose.material3:material3:1.3.0`
    - `androidx.compose.ui:ui-tooling-preview`
    - `androidx.compose.ui:ui-tooling` (debug only)
  - Author: Google / Android Open Source Project
  - Source: https://cs.android.com/androidx/platform/frameworks/support
  - License: Apache License 2.0

---

## Tooling & Build

- **Gradle Build System**
  - License: Apache License 2.0
  - Source: https://gradle.org/

- **Android Gradle Plugin (AGP)**
  - License: Apache License 2.0
  - Source: https://developer.android.com/studio/build

---

## Notes
- This app contains **no proprietary dependencies** (e.g., Firebase, Google Play Services).
- All libraries are either **Apache 2.0** or **Public Domain**, compatible with F-Droid.
- Icons and artwork are original and licensed by the project author.
