import 'dart:collection';

import 'package:simple_sparse_list/simple_sparse_list.dart';

import '../decomposer.dart';

class WideDecomposer extends Decomposer {
  const WideDecomposer();

  @override
  List<int>? decompose(int character) {
    if (character < 0 || character > 1114111) {
      throw RangeError.range(character, 0, 1114111, 'character');
    }

    final result = _data[character];
    return result?.toList();
  }

  @override
  List<(int, List<int>)> getMappingList() {
    final groups = _data.getGroups();
    final result = groups.map((e) => (e.$1, e.$3!));
    return UnmodifiableListView(result);
  }
}

SparseList<List<int>?> _unpack(List<(int, List<int>)> data) {
  final list = <(int, int, List<int>)>[];
  var prev = 0;
  for (var i = 0; i < data.length; i++) {
    final element = data[i];
    final code = element.$1 + prev;
    list.add((code, code, element.$2));
    prev = code;
  }

  return SparseList(list, null, length: 0x110000);
}

final _data = _unpack(const [(12288, [32]), (52993, [33]), (1, [34]), (1, [35]), (1, [36]), (1, [37]), (1, [38]), (1, [39]), (1, [40]), (1, [41]), (1, [42]), (1, [43]), (1, [44]), (1, [45]), (1, [46]), (1, [47]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [58]), (1, [59]), (1, [60]), (1, [61]), (1, [62]), (1, [63]), (1, [64]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [91]), (1, [92]), (1, [93]), (1, [94]), (1, [95]), (1, [96]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [123]), (1, [124]), (1, [125]), (1, [126]), (1, [10629]), (1, [10630]), (128, [162]), (1, [163]), (1, [172]), (1, [175]), (1, [166]), (1, [165]), (1, [8361])]);
