import 'dart:collection';

import 'package:simple_sparse_list/simple_sparse_list.dart';

import '../decomposer.dart';

class SuperDecomposer extends Decomposer {
  const SuperDecomposer();

  @override
  List<int>? decompose(int character) {
    if (character < 0 || character > 1114111) {
      throw RangeError.range(character, 0, 1114111, 'character');
    }

    final result = _data[character];
    return result?.toList();
  }

  @override
  List<(int, List<int>)> getMappingList() {
    final groups = _data.getGroups();
    final result = groups.map((e) => (e.$1, e.$3!));
    return UnmodifiableListView(result);
  }
}

SparseList<List<int>?> _unpack(List<(int, List<int>)> data) {
  final list = <(int, int, List<int>)>[];
  var prev = 0;
  for (var i = 0; i < data.length; i++) {
    final element = data[i];
    final code = element.$1 + prev;
    list.add((code, code, element.$2));
    prev = code;
  }

  return SparseList(list, null, length: 0x110000);
}

final _data = _unpack(const [(170, [97]), (8, [50]), (1, [51]), (6, [49]), (1, [111]), (502, [104]), (1, [614]), (1, [106]), (1, [114]), (1, [633]), (1, [635]), (1, [641]), (1, [119]), (1, [121]), (40, [611]), (1, [108]), (1, [115]), (1, [120]), (1, [661]), (3608, [4316]), (3120, [65]), (1, [198]), (1, [66]), (2, [68]), (1, [69]), (1, [398]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (2, [79]), (1, [546]), (1, [80]), (1, [82]), (1, [84]), (1, [85]), (1, [87]), (1, [97]), (1, [592]), (1, [593]), (1, [7426]), (1, [98]), (1, [100]), (1, [101]), (1, [601]), (1, [603]), (1, [604]), (1, [103]), (2, [107]), (1, [109]), (1, [331]), (1, [111]), (1, [596]), (1, [7446]), (1, [7447]), (1, [112]), (1, [116]), (1, [117]), (1, [7453]), (1, [623]), (1, [118]), (1, [7461]), (1, [946]), (1, [947]), (1, [948]), (1, [966]), (1, [967]), (23, [1085]), (35, [594]), (1, [99]), (1, [597]), (1, [240]), (1, [604]), (1, [102]), (1, [607]), (1, [609]), (1, [613]), (1, [616]), (1, [617]), (1, [618]), (1, [7547]), (1, [669]), (1, [621]), (1, [7557]), (1, [671]), (1, [625]), (1, [624]), (1, [626]), (1, [627]), (1, [628]), (1, [629]), (1, [632]), (1, [642]), (1, [643]), (1, [427]), (1, [649]), (1, [650]), (1, [7452]), (1, [651]), (1, [652]), (1, [122]), (1, [656]), (1, [657]), (1, [658]), (1, [952]), (689, [48]), (1, [105]), (3, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [43]), (1, [8722]), (1, [61]), (1, [40]), (1, [41]), (1, [110]), (161, [83, 77]), (2, [84, 77]), (2907, [86]), (242, [11617]), (1059, [19968]), (1, [20108]), (1, [19977]), (1, [22235]), (1, [19978]), (1, [20013]), (1, [19979]), (1, [30002]), (1, [20057]), (1, [19993]), (1, [19969]), (1, [22825]), (1, [22320]), (1, [20154]), (29949, [1098]), (1, [1100]), (211, [42863]), (130, [67]), (1, [70]), (1, [81]), (4, [294]), (1, [339]), (867, [42791]), (1, [43831]), (1, [619]), (1, [43858]), (10, [653]), (23576, [720]), (1, [721]), (1, [230]), (1, [665]), (1, [595]), (2, [675]), (1, [43878]), (1, [677]), (1, [676]), (1, [598]), (1, [599]), (1, [7569]), (1, [600]), (1, [606]), (1, [681]), (1, [612]), (1, [610]), (1, [608]), (1, [667]), (1, [295]), (1, [668]), (1, [615]), (1, [644]), (1, [682]), (1, [683]), (1, [620]), (1, [122628]), (1, [42894]), (1, [622]), (1, [122629]), (1, [654]), (1, [122630]), (1, [248]), (1, [630]), (1, [631]), (1, [113]), (1, [634]), (1, [122632]), (1, [637]), (1, [638]), (1, [640]), (1, [680]), (1, [678]), (1, [43879]), (1, [679]), (1, [648]), (1, [11377]), (2, [655]), (1, [673]), (1, [674]), (1, [664]), (1, [448]), (1, [449]), (1, [450]), (1, [122634]), (1, [122654]), (55414, [1072]), (1, [1073]), (1, [1074]), (1, [1075]), (1, [1076]), (1, [1077]), (1, [1078]), (1, [1079]), (1, [1080]), (1, [1082]), (1, [1083]), (1, [1084]), (1, [1086]), (1, [1087]), (1, [1088]), (1, [1089]), (1, [1090]), (1, [1091]), (1, [1092]), (1, [1093]), (1, [1094]), (1, [1095]), (1, [1096]), (1, [1099]), (1, [1101]), (1, [1102]), (1, [42633]), (1, [1241]), (1, [1110]), (1, [1112]), (1, [1257]), (1, [1199]), (1, [1231]), (27, [1195]), (1, [42577]), (1, [1201]), (4349, [77, 67]), (1, [77, 68]), (1, [77, 82])]);
