import 'dart:collection';

import 'package:simple_sparse_list/simple_sparse_list.dart';

import '../decomposer.dart';

class NarrowDecomposer extends Decomposer {
  const NarrowDecomposer();

  @override
  List<int>? decompose(int character) {
    if (character < 0 || character > 1114111) {
      throw RangeError.range(character, 0, 1114111, 'character');
    }

    final result = _data[character];
    return result?.toList();
  }

  @override
  List<(int, List<int>)> getMappingList() {
    final groups = _data.getGroups();
    final result = groups.map((e) => (e.$1, e.$3!));
    return UnmodifiableListView(result);
  }
}

SparseList<List<int>?> _unpack(List<(int, List<int>)> data) {
  final list = <(int, int, List<int>)>[];
  var prev = 0;
  for (var i = 0; i < data.length; i++) {
    final element = data[i];
    final code = element.$1 + prev;
    list.add((code, code, element.$2));
    prev = code;
  }

  return SparseList(list, null, length: 0x110000);
}

final _data = _unpack(const [(65377, [12290]), (1, [12300]), (1, [12301]), (1, [12289]), (1, [12539]), (1, [12530]), (1, [12449]), (1, [12451]), (1, [12453]), (1, [12455]), (1, [12457]), (1, [12515]), (1, [12517]), (1, [12519]), (1, [12483]), (1, [12540]), (1, [12450]), (1, [12452]), (1, [12454]), (1, [12456]), (1, [12458]), (1, [12459]), (1, [12461]), (1, [12463]), (1, [12465]), (1, [12467]), (1, [12469]), (1, [12471]), (1, [12473]), (1, [12475]), (1, [12477]), (1, [12479]), (1, [12481]), (1, [12484]), (1, [12486]), (1, [12488]), (1, [12490]), (1, [12491]), (1, [12492]), (1, [12493]), (1, [12494]), (1, [12495]), (1, [12498]), (1, [12501]), (1, [12504]), (1, [12507]), (1, [12510]), (1, [12511]), (1, [12512]), (1, [12513]), (1, [12514]), (1, [12516]), (1, [12518]), (1, [12520]), (1, [12521]), (1, [12522]), (1, [12523]), (1, [12524]), (1, [12525]), (1, [12527]), (1, [12531]), (1, [12441]), (1, [12442]), (1, [12644]), (1, [12593]), (1, [12594]), (1, [12595]), (1, [12596]), (1, [12597]), (1, [12598]), (1, [12599]), (1, [12600]), (1, [12601]), (1, [12602]), (1, [12603]), (1, [12604]), (1, [12605]), (1, [12606]), (1, [12607]), (1, [12608]), (1, [12609]), (1, [12610]), (1, [12611]), (1, [12612]), (1, [12613]), (1, [12614]), (1, [12615]), (1, [12616]), (1, [12617]), (1, [12618]), (1, [12619]), (1, [12620]), (1, [12621]), (1, [12622]), (4, [12623]), (1, [12624]), (1, [12625]), (1, [12626]), (1, [12627]), (1, [12628]), (3, [12629]), (1, [12630]), (1, [12631]), (1, [12632]), (1, [12633]), (1, [12634]), (3, [12635]), (1, [12636]), (1, [12637]), (1, [12638]), (1, [12639]), (1, [12640]), (3, [12641]), (1, [12642]), (1, [12643]), (12, [9474]), (1, [8592]), (1, [8593]), (1, [8594]), (1, [8595]), (1, [9632]), (1, [9675])]);
