import 'dart:collection';

import 'package:simple_sparse_list/simple_sparse_list.dart';

import '../decomposer.dart';

class FontDecomposer extends Decomposer {
  const FontDecomposer();

  @override
  List<int>? decompose(int character) {
    if (character < 0 || character > 1114111) {
      throw RangeError.range(character, 0, 1114111, 'character');
    }

    final result = _data[character];
    return result?.toList();
  }

  @override
  List<(int, List<int>)> getMappingList() {
    final groups = _data.getGroups();
    final result = groups.map((e) => (e.$1, e.$3!));
    return UnmodifiableListView(result);
  }
}

SparseList<List<int>?> _unpack(List<(int, List<int>)> data) {
  final list = <(int, int, List<int>)>[];
  var prev = 0;
  for (var i = 0; i < data.length; i++) {
    final element = data[i];
    final code = element.$1 + prev;
    list.add((code, code, element.$2));
    prev = code;
  }

  return SparseList(list, null, length: 0x110000);
}

final _data = _unpack(const [(8450, [67]), (8, [103]), (1, [72]), (1, [72]), (1, [72]), (1, [104]), (1, [295]), (1, [73]), (1, [73]), (1, [76]), (1, [108]), (2, [78]), (4, [80]), (1, [81]), (1, [82]), (1, [82]), (1, [82]), (7, [90]), (4, [90]), (4, [66]), (1, [67]), (2, [101]), (1, [69]), (1, [70]), (2, [77]), (1, [111]), (5, [105]), (3, [960]), (1, [947]), (1, [915]), (1, [928]), (1, [8721]), (5, [68]), (1, [100]), (1, [101]), (1, [105]), (1, [106]), (55767, [1506]), (1, [1488]), (1, [1491]), (1, [1492]), (1, [1499]), (1, [1500]), (1, [1501]), (1, [1512]), (1, [1514]), (1, [43]), (53677, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1799, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (2, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (2, [67]), (1, [68]), (3, [71]), (3, [74]), (1, [75]), (3, [78]), (1, [79]), (1, [80]), (1, [81]), (2, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (2, [102]), (2, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (2, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (2, [68]), (1, [69]), (1, [70]), (1, [71]), (3, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (2, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (2, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (2, [68]), (1, [69]), (1, [70]), (1, [71]), (2, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (2, [79]), (4, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (2, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [65]), (1, [66]), (1, [67]), (1, [68]), (1, [69]), (1, [70]), (1, [71]), (1, [72]), (1, [73]), (1, [74]), (1, [75]), (1, [76]), (1, [77]), (1, [78]), (1, [79]), (1, [80]), (1, [81]), (1, [82]), (1, [83]), (1, [84]), (1, [85]), (1, [86]), (1, [87]), (1, [88]), (1, [89]), (1, [90]), (1, [97]), (1, [98]), (1, [99]), (1, [100]), (1, [101]), (1, [102]), (1, [103]), (1, [104]), (1, [105]), (1, [106]), (1, [107]), (1, [108]), (1, [109]), (1, [110]), (1, [111]), (1, [112]), (1, [113]), (1, [114]), (1, [115]), (1, [116]), (1, [117]), (1, [118]), (1, [119]), (1, [120]), (1, [121]), (1, [122]), (1, [305]), (1, [567]), (3, [913]), (1, [914]), (1, [915]), (1, [916]), (1, [917]), (1, [918]), (1, [919]), (1, [920]), (1, [921]), (1, [922]), (1, [923]), (1, [924]), (1, [925]), (1, [926]), (1, [927]), (1, [928]), (1, [929]), (1, [1012]), (1, [931]), (1, [932]), (1, [933]), (1, [934]), (1, [935]), (1, [936]), (1, [937]), (1, [8711]), (1, [945]), (1, [946]), (1, [947]), (1, [948]), (1, [949]), (1, [950]), (1, [951]), (1, [952]), (1, [953]), (1, [954]), (1, [955]), (1, [956]), (1, [957]), (1, [958]), (1, [959]), (1, [960]), (1, [961]), (1, [962]), (1, [963]), (1, [964]), (1, [965]), (1, [966]), (1, [967]), (1, [968]), (1, [969]), (1, [8706]), (1, [1013]), (1, [977]), (1, [1008]), (1, [981]), (1, [1009]), (1, [982]), (1, [913]), (1, [914]), (1, [915]), (1, [916]), (1, [917]), (1, [918]), (1, [919]), (1, [920]), (1, [921]), (1, [922]), (1, [923]), (1, [924]), (1, [925]), (1, [926]), (1, [927]), (1, [928]), (1, [929]), (1, [1012]), (1, [931]), (1, [932]), (1, [933]), (1, [934]), (1, [935]), (1, [936]), (1, [937]), (1, [8711]), (1, [945]), (1, [946]), (1, [947]), (1, [948]), (1, [949]), (1, [950]), (1, [951]), (1, [952]), (1, [953]), (1, [954]), (1, [955]), (1, [956]), (1, [957]), (1, [958]), (1, [959]), (1, [960]), (1, [961]), (1, [962]), (1, [963]), (1, [964]), (1, [965]), (1, [966]), (1, [967]), (1, [968]), (1, [969]), (1, [8706]), (1, [1013]), (1, [977]), (1, [1008]), (1, [981]), (1, [1009]), (1, [982]), (1, [913]), (1, [914]), (1, [915]), (1, [916]), (1, [917]), (1, [918]), (1, [919]), (1, [920]), (1, [921]), (1, [922]), (1, [923]), (1, [924]), (1, [925]), (1, [926]), (1, [927]), (1, [928]), (1, [929]), (1, [1012]), (1, [931]), (1, [932]), (1, [933]), (1, [934]), (1, [935]), (1, [936]), (1, [937]), (1, [8711]), (1, [945]), (1, [946]), (1, [947]), (1, [948]), (1, [949]), (1, [950]), (1, [951]), (1, [952]), (1, [953]), (1, [954]), (1, [955]), (1, [956]), (1, [957]), (1, [958]), (1, [959]), (1, [960]), (1, [961]), (1, [962]), (1, [963]), (1, [964]), (1, [965]), (1, [966]), (1, [967]), (1, [968]), (1, [969]), (1, [8706]), (1, [1013]), (1, [977]), (1, [1008]), (1, [981]), (1, [1009]), (1, [982]), (1, [913]), (1, [914]), (1, [915]), (1, [916]), (1, [917]), (1, [918]), (1, [919]), (1, [920]), (1, [921]), (1, [922]), (1, [923]), (1, [924]), (1, [925]), (1, [926]), (1, [927]), (1, [928]), (1, [929]), (1, [1012]), (1, [931]), (1, [932]), (1, [933]), (1, [934]), (1, [935]), (1, [936]), (1, [937]), (1, [8711]), (1, [945]), (1, [946]), (1, [947]), (1, [948]), (1, [949]), (1, [950]), (1, [951]), (1, [952]), (1, [953]), (1, [954]), (1, [955]), (1, [956]), (1, [957]), (1, [958]), (1, [959]), (1, [960]), (1, [961]), (1, [962]), (1, [963]), (1, [964]), (1, [965]), (1, [966]), (1, [967]), (1, [968]), (1, [969]), (1, [8706]), (1, [1013]), (1, [977]), (1, [1008]), (1, [981]), (1, [1009]), (1, [982]), (1, [913]), (1, [914]), (1, [915]), (1, [916]), (1, [917]), (1, [918]), (1, [919]), (1, [920]), (1, [921]), (1, [922]), (1, [923]), (1, [924]), (1, [925]), (1, [926]), (1, [927]), (1, [928]), (1, [929]), (1, [1012]), (1, [931]), (1, [932]), (1, [933]), (1, [934]), (1, [935]), (1, [936]), (1, [937]), (1, [8711]), (1, [945]), (1, [946]), (1, [947]), (1, [948]), (1, [949]), (1, [950]), (1, [951]), (1, [952]), (1, [953]), (1, [954]), (1, [955]), (1, [956]), (1, [957]), (1, [958]), (1, [959]), (1, [960]), (1, [961]), (1, [962]), (1, [963]), (1, [964]), (1, [965]), (1, [966]), (1, [967]), (1, [968]), (1, [969]), (1, [8706]), (1, [1013]), (1, [977]), (1, [1008]), (1, [981]), (1, [1009]), (1, [982]), (1, [988]), (1, [989]), (3, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (1, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57]), (5633, [1575]), (1, [1576]), (1, [1580]), (1, [1583]), (2, [1608]), (1, [1586]), (1, [1581]), (1, [1591]), (1, [1610]), (1, [1603]), (1, [1604]), (1, [1605]), (1, [1606]), (1, [1587]), (1, [1593]), (1, [1601]), (1, [1589]), (1, [1602]), (1, [1585]), (1, [1588]), (1, [1578]), (1, [1579]), (1, [1582]), (1, [1584]), (1, [1590]), (1, [1592]), (1, [1594]), (1, [1646]), (1, [1722]), (1, [1697]), (1, [1647]), (2, [1576]), (1, [1580]), (2, [1607]), (3, [1581]), (2, [1610]), (1, [1603]), (1, [1604]), (1, [1605]), (1, [1606]), (1, [1587]), (1, [1593]), (1, [1601]), (1, [1589]), (1, [1602]), (2, [1588]), (1, [1578]), (1, [1579]), (1, [1582]), (2, [1590]), (2, [1594]), (7, [1580]), (5, [1581]), (2, [1610]), (2, [1604]), (2, [1606]), (1, [1587]), (1, [1593]), (2, [1589]), (1, [1602]), (2, [1588]), (3, [1582]), (2, [1590]), (2, [1594]), (2, [1722]), (2, [1647]), (2, [1576]), (1, [1580]), (2, [1607]), (3, [1581]), (1, [1591]), (1, [1610]), (1, [1603]), (2, [1605]), (1, [1606]), (1, [1587]), (1, [1593]), (1, [1601]), (1, [1589]), (1, [1602]), (2, [1588]), (1, [1578]), (1, [1579]), (1, [1582]), (2, [1590]), (1, [1592]), (1, [1594]), (1, [1646]), (2, [1697]), (2, [1575]), (1, [1576]), (1, [1580]), (1, [1583]), (1, [1607]), (1, [1608]), (1, [1586]), (1, [1581]), (1, [1591]), (1, [1610]), (2, [1604]), (1, [1605]), (1, [1606]), (1, [1587]), (1, [1593]), (1, [1601]), (1, [1589]), (1, [1602]), (1, [1585]), (1, [1588]), (1, [1578]), (1, [1579]), (1, [1582]), (1, [1584]), (1, [1590]), (1, [1592]), (1, [1594]), (6, [1576]), (1, [1580]), (1, [1583]), (2, [1608]), (1, [1586]), (1, [1581]), (1, [1591]), (1, [1610]), (2, [1604]), (1, [1605]), (1, [1606]), (1, [1587]), (1, [1593]), (1, [1601]), (1, [1589]), (1, [1602]), (1, [1585]), (1, [1588]), (1, [1578]), (1, [1579]), (1, [1582]), (1, [1584]), (1, [1590]), (1, [1592]), (1, [1594]), (3381, [48]), (1, [49]), (1, [50]), (1, [51]), (1, [52]), (1, [53]), (1, [54]), (1, [55]), (1, [56]), (1, [57])]);
